// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.Incident;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Incident Request.
 */
public class IncidentRequest extends BaseRequest<Incident> {
	
    /**
     * The request for the Incident
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public IncidentRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Incident.class);
    }

    /**
     * Gets the Incident from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Incident> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Incident from the service
     *
     * @return the Incident from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Incident get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Incident> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Incident delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Incident with a source
     *
     * @param sourceIncident the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Incident> patchAsync(@Nonnull final Incident sourceIncident) {
        return sendAsync(HttpMethod.PATCH, sourceIncident);
    }

    /**
     * Patches this Incident with a source
     *
     * @param sourceIncident the source object with updates
     * @return the updated Incident
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Incident patch(@Nonnull final Incident sourceIncident) throws ClientException {
        return send(HttpMethod.PATCH, sourceIncident);
    }

    /**
     * Creates a Incident with a new object
     *
     * @param newIncident the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Incident> postAsync(@Nonnull final Incident newIncident) {
        return sendAsync(HttpMethod.POST, newIncident);
    }

    /**
     * Creates a Incident with a new object
     *
     * @param newIncident the new object to create
     * @return the created Incident
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Incident post(@Nonnull final Incident newIncident) throws ClientException {
        return send(HttpMethod.POST, newIncident);
    }

    /**
     * Creates a Incident with a new object
     *
     * @param newIncident the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Incident> putAsync(@Nonnull final Incident newIncident) {
        return sendAsync(HttpMethod.PUT, newIncident);
    }

    /**
     * Creates a Incident with a new object
     *
     * @param newIncident the object to create/update
     * @return the created Incident
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Incident put(@Nonnull final Incident newIncident) throws ClientException {
        return send(HttpMethod.PUT, newIncident);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public IncidentRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public IncidentRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

