// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.PrinterBase;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Printer Base Request.
 */
public class PrinterBaseRequest extends BaseRequest<PrinterBase> {
	
    /**
     * The request for the PrinterBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public PrinterBaseRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends PrinterBase> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the PrinterBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PrinterBaseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, PrinterBase.class);
    }

    /**
     * Gets the PrinterBase from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterBase> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the PrinterBase from the service
     *
     * @return the PrinterBase from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrinterBase get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterBase> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public PrinterBase delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this PrinterBase with a source
     *
     * @param sourcePrinterBase the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterBase> patchAsync(@Nonnull final PrinterBase sourcePrinterBase) {
        return sendAsync(HttpMethod.PATCH, sourcePrinterBase);
    }

    /**
     * Patches this PrinterBase with a source
     *
     * @param sourcePrinterBase the source object with updates
     * @return the updated PrinterBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrinterBase patch(@Nonnull final PrinterBase sourcePrinterBase) throws ClientException {
        return send(HttpMethod.PATCH, sourcePrinterBase);
    }

    /**
     * Creates a PrinterBase with a new object
     *
     * @param newPrinterBase the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterBase> postAsync(@Nonnull final PrinterBase newPrinterBase) {
        return sendAsync(HttpMethod.POST, newPrinterBase);
    }

    /**
     * Creates a PrinterBase with a new object
     *
     * @param newPrinterBase the new object to create
     * @return the created PrinterBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrinterBase post(@Nonnull final PrinterBase newPrinterBase) throws ClientException {
        return send(HttpMethod.POST, newPrinterBase);
    }

    /**
     * Creates a PrinterBase with a new object
     *
     * @param newPrinterBase the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<PrinterBase> putAsync(@Nonnull final PrinterBase newPrinterBase) {
        return sendAsync(HttpMethod.PUT, newPrinterBase);
    }

    /**
     * Creates a PrinterBase with a new object
     *
     * @param newPrinterBase the object to create/update
     * @return the created PrinterBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public PrinterBase put(@Nonnull final PrinterBase newPrinterBase) throws ClientException {
        return send(HttpMethod.PUT, newPrinterBase);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public PrinterBaseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public PrinterBaseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

