// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.BrowserSiteListPublishRequest;
import com.microsoft.graph.models.BrowserSite;
import com.microsoft.graph.models.BrowserSharedCookie;
import com.microsoft.graph.models.BrowserSiteList;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.BrowserSiteListPublishParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Browser Site List Publish Request Builder.
 */
public class BrowserSiteListPublishRequestBuilder extends BaseActionRequestBuilder<BrowserSiteList> {

    /**
     * The request builder for this BrowserSiteListPublish
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public BrowserSiteListPublishRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private BrowserSiteListPublishParameterSet body;
    /**
     * The request builder for this BrowserSiteListPublish
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public BrowserSiteListPublishRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final BrowserSiteListPublishParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the BrowserSiteListPublishRequest
     *
     * @param requestOptions the options for the request
     * @return the BrowserSiteListPublishRequest instance
     */
    @Nonnull
    public BrowserSiteListPublishRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the BrowserSiteListPublishRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the BrowserSiteListPublishRequest instance
     */
    @Nonnull
    public BrowserSiteListPublishRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final BrowserSiteListPublishRequest request = new BrowserSiteListPublishRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
