// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest;
import com.microsoft.graph.models.AuthenticationStrengthPolicy;
import com.microsoft.graph.models.AuthenticationMethodModes;
import com.microsoft.graph.models.UpdateAllowedCombinationsResult;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.models.AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Strength Policy Update Allowed Combinations Request Builder.
 */
public class AuthenticationStrengthPolicyUpdateAllowedCombinationsRequestBuilder extends BaseActionRequestBuilder<UpdateAllowedCombinationsResult> {

    /**
     * The request builder for this AuthenticationStrengthPolicyUpdateAllowedCombinations
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationStrengthPolicyUpdateAllowedCombinationsRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }
    private AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet body;
    /**
     * The request builder for this AuthenticationStrengthPolicyUpdateAllowedCombinations
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param parameters     the parameters for the service method
     */
    public AuthenticationStrengthPolicyUpdateAllowedCombinationsRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, @Nonnull final AuthenticationStrengthPolicyUpdateAllowedCombinationsParameterSet parameters) {
        super(requestUrl, client, requestOptions);
        this.body = parameters;
    }

    /**
     * Creates the AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest
     *
     * @param requestOptions the options for the request
     * @return the AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest instance
     */
    @Nonnull
    public AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest instance
     */
    @Nonnull
    public AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest request = new AuthenticationStrengthPolicyUpdateAllowedCombinationsRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        request.body = this.body;
        return request;
    }
}
