// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.security.models.EdiscoveryHoldOperation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ediscovery Hold Operation Request.
 */
public class EdiscoveryHoldOperationRequest extends BaseRequest<EdiscoveryHoldOperation> {
	
    /**
     * The request for the EdiscoveryHoldOperation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public EdiscoveryHoldOperationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, EdiscoveryHoldOperation.class);
    }

    /**
     * Gets the EdiscoveryHoldOperation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryHoldOperation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the EdiscoveryHoldOperation from the service
     *
     * @return the EdiscoveryHoldOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryHoldOperation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryHoldOperation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public EdiscoveryHoldOperation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this EdiscoveryHoldOperation with a source
     *
     * @param sourceEdiscoveryHoldOperation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryHoldOperation> patchAsync(@Nonnull final EdiscoveryHoldOperation sourceEdiscoveryHoldOperation) {
        return sendAsync(HttpMethod.PATCH, sourceEdiscoveryHoldOperation);
    }

    /**
     * Patches this EdiscoveryHoldOperation with a source
     *
     * @param sourceEdiscoveryHoldOperation the source object with updates
     * @return the updated EdiscoveryHoldOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryHoldOperation patch(@Nonnull final EdiscoveryHoldOperation sourceEdiscoveryHoldOperation) throws ClientException {
        return send(HttpMethod.PATCH, sourceEdiscoveryHoldOperation);
    }

    /**
     * Creates a EdiscoveryHoldOperation with a new object
     *
     * @param newEdiscoveryHoldOperation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryHoldOperation> postAsync(@Nonnull final EdiscoveryHoldOperation newEdiscoveryHoldOperation) {
        return sendAsync(HttpMethod.POST, newEdiscoveryHoldOperation);
    }

    /**
     * Creates a EdiscoveryHoldOperation with a new object
     *
     * @param newEdiscoveryHoldOperation the new object to create
     * @return the created EdiscoveryHoldOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryHoldOperation post(@Nonnull final EdiscoveryHoldOperation newEdiscoveryHoldOperation) throws ClientException {
        return send(HttpMethod.POST, newEdiscoveryHoldOperation);
    }

    /**
     * Creates a EdiscoveryHoldOperation with a new object
     *
     * @param newEdiscoveryHoldOperation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<EdiscoveryHoldOperation> putAsync(@Nonnull final EdiscoveryHoldOperation newEdiscoveryHoldOperation) {
        return sendAsync(HttpMethod.PUT, newEdiscoveryHoldOperation);
    }

    /**
     * Creates a EdiscoveryHoldOperation with a new object
     *
     * @param newEdiscoveryHoldOperation the object to create/update
     * @return the created EdiscoveryHoldOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public EdiscoveryHoldOperation put(@Nonnull final EdiscoveryHoldOperation newEdiscoveryHoldOperation) throws ClientException {
        return send(HttpMethod.PUT, newEdiscoveryHoldOperation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryHoldOperationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public EdiscoveryHoldOperationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

