// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Topic Modeling Settings.
 */
public class TopicModelingSettings implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Dynamically Adjust Topic Count.
     * Indicates whether the themes model should dynamically optimize the number of generated topics. To learn more, see Adjust maximum number of themes dynamically.
     */
    @SerializedName(value = "dynamicallyAdjustTopicCount", alternate = {"DynamicallyAdjustTopicCount"})
    @Expose
	@Nullable
    public Boolean dynamicallyAdjustTopicCount;

    /**
     * The Ignore Numbers.
     * Indicates whether the themes model should exclude numbers while parsing document texts. To learn more, see Include numbers in themes.
     */
    @SerializedName(value = "ignoreNumbers", alternate = {"IgnoreNumbers"})
    @Expose
	@Nullable
    public Boolean ignoreNumbers;

    /**
     * The Is Enabled.
     * Indicates whether themes model is enabled for the case.
     */
    @SerializedName(value = "isEnabled", alternate = {"IsEnabled"})
    @Expose
	@Nullable
    public Boolean isEnabled;

    /**
     * The Topic Count.
     * The total number of topics that the themes model will generate for a review set. To learn more, see Maximum number of themes.
     */
    @SerializedName(value = "topicCount", alternate = {"TopicCount"})
    @Expose
	@Nullable
    public Integer topicCount;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
