// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.security.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.security.models.EvidenceRemediationStatus;
import com.microsoft.graph.security.models.EvidenceRole;
import com.microsoft.graph.security.models.EvidenceVerdict;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Alert Evidence.
 */
public class AlertEvidence implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Created Date Time.
     * The time the evidence was created and added to the alert.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Remediation Status.
     * Status of the remediation action taken. The possible values are: none, remediated, prevented, blocked, notFound, unknownFutureValue.
     */
    @SerializedName(value = "remediationStatus", alternate = {"RemediationStatus"})
    @Expose
	@Nullable
    public EvidenceRemediationStatus remediationStatus;

    /**
     * The Remediation Status Details.
     * Details about the remediation status.
     */
    @SerializedName(value = "remediationStatusDetails", alternate = {"RemediationStatusDetails"})
    @Expose
	@Nullable
    public String remediationStatusDetails;

    /**
     * The Roles.
     * The role/s that an evidence entity represents in an alert, e.g., an IP address that is associated with an attacker will have the evidence role 'Attacker'.
     */
    @SerializedName(value = "roles", alternate = {"Roles"})
    @Expose
	@Nullable
    public java.util.List<EvidenceRole> roles;

    /**
     * The Tags.
     * Array of custom tags associated with an evidence instance, for example to denote a group of devices, high value assets, etc.
     */
    @SerializedName(value = "tags", alternate = {"Tags"})
    @Expose
	@Nullable
    public java.util.List<String> tags;

    /**
     * The Verdict.
     * The decision reached by automated investigation. The possible values are: unknown, suspicious, malicious, noThreatsFound, unknownFutureValue.
     */
    @SerializedName(value = "verdict", alternate = {"Verdict"})
    @Expose
	@Nullable
    public EvidenceVerdict verdict;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
