// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.UnifiedRbacResourceNamespace;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Unified Rbac Resource Namespace Request.
 */
public class UnifiedRbacResourceNamespaceRequest extends BaseRequest<UnifiedRbacResourceNamespace> {
	
    /**
     * The request for the UnifiedRbacResourceNamespace
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UnifiedRbacResourceNamespaceRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UnifiedRbacResourceNamespace.class);
    }

    /**
     * Gets the UnifiedRbacResourceNamespace from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRbacResourceNamespace> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the UnifiedRbacResourceNamespace from the service
     *
     * @return the UnifiedRbacResourceNamespace from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRbacResourceNamespace get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRbacResourceNamespace> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public UnifiedRbacResourceNamespace delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this UnifiedRbacResourceNamespace with a source
     *
     * @param sourceUnifiedRbacResourceNamespace the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRbacResourceNamespace> patchAsync(@Nonnull final UnifiedRbacResourceNamespace sourceUnifiedRbacResourceNamespace) {
        return sendAsync(HttpMethod.PATCH, sourceUnifiedRbacResourceNamespace);
    }

    /**
     * Patches this UnifiedRbacResourceNamespace with a source
     *
     * @param sourceUnifiedRbacResourceNamespace the source object with updates
     * @return the updated UnifiedRbacResourceNamespace
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRbacResourceNamespace patch(@Nonnull final UnifiedRbacResourceNamespace sourceUnifiedRbacResourceNamespace) throws ClientException {
        return send(HttpMethod.PATCH, sourceUnifiedRbacResourceNamespace);
    }

    /**
     * Creates a UnifiedRbacResourceNamespace with a new object
     *
     * @param newUnifiedRbacResourceNamespace the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRbacResourceNamespace> postAsync(@Nonnull final UnifiedRbacResourceNamespace newUnifiedRbacResourceNamespace) {
        return sendAsync(HttpMethod.POST, newUnifiedRbacResourceNamespace);
    }

    /**
     * Creates a UnifiedRbacResourceNamespace with a new object
     *
     * @param newUnifiedRbacResourceNamespace the new object to create
     * @return the created UnifiedRbacResourceNamespace
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRbacResourceNamespace post(@Nonnull final UnifiedRbacResourceNamespace newUnifiedRbacResourceNamespace) throws ClientException {
        return send(HttpMethod.POST, newUnifiedRbacResourceNamespace);
    }

    /**
     * Creates a UnifiedRbacResourceNamespace with a new object
     *
     * @param newUnifiedRbacResourceNamespace the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<UnifiedRbacResourceNamespace> putAsync(@Nonnull final UnifiedRbacResourceNamespace newUnifiedRbacResourceNamespace) {
        return sendAsync(HttpMethod.PUT, newUnifiedRbacResourceNamespace);
    }

    /**
     * Creates a UnifiedRbacResourceNamespace with a new object
     *
     * @param newUnifiedRbacResourceNamespace the object to create/update
     * @return the created UnifiedRbacResourceNamespace
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public UnifiedRbacResourceNamespace put(@Nonnull final UnifiedRbacResourceNamespace newUnifiedRbacResourceNamespace) throws ClientException {
        return send(HttpMethod.PUT, newUnifiedRbacResourceNamespace);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRbacResourceNamespaceRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public UnifiedRbacResourceNamespaceRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

