// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SectionGroup;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Section Group Request.
 */
public class SectionGroupRequest extends BaseRequest<SectionGroup> {
	
    /**
     * The request for the SectionGroup
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SectionGroupRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SectionGroup.class);
    }

    /**
     * Gets the SectionGroup from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SectionGroup> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SectionGroup from the service
     *
     * @return the SectionGroup from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SectionGroup get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SectionGroup> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SectionGroup delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SectionGroup with a source
     *
     * @param sourceSectionGroup the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SectionGroup> patchAsync(@Nonnull final SectionGroup sourceSectionGroup) {
        return sendAsync(HttpMethod.PATCH, sourceSectionGroup);
    }

    /**
     * Patches this SectionGroup with a source
     *
     * @param sourceSectionGroup the source object with updates
     * @return the updated SectionGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SectionGroup patch(@Nonnull final SectionGroup sourceSectionGroup) throws ClientException {
        return send(HttpMethod.PATCH, sourceSectionGroup);
    }

    /**
     * Creates a SectionGroup with a new object
     *
     * @param newSectionGroup the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SectionGroup> postAsync(@Nonnull final SectionGroup newSectionGroup) {
        return sendAsync(HttpMethod.POST, newSectionGroup);
    }

    /**
     * Creates a SectionGroup with a new object
     *
     * @param newSectionGroup the new object to create
     * @return the created SectionGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SectionGroup post(@Nonnull final SectionGroup newSectionGroup) throws ClientException {
        return send(HttpMethod.POST, newSectionGroup);
    }

    /**
     * Creates a SectionGroup with a new object
     *
     * @param newSectionGroup the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SectionGroup> putAsync(@Nonnull final SectionGroup newSectionGroup) {
        return sendAsync(HttpMethod.PUT, newSectionGroup);
    }

    /**
     * Creates a SectionGroup with a new object
     *
     * @param newSectionGroup the object to create/update
     * @return the created SectionGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SectionGroup put(@Nonnull final SectionGroup newSectionGroup) throws ClientException {
        return send(HttpMethod.PUT, newSectionGroup);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SectionGroupRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SectionGroupRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

