// Template Source: BaseMethodRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;
import com.microsoft.graph.requests.PhoneAuthenticationMethodDisableSmsSignInRequest;
import com.microsoft.graph.models.PhoneAuthenticationMethod;

import com.microsoft.graph.http.BaseActionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Phone Authentication Method Disable Sms Sign In Request Builder.
 */
public class PhoneAuthenticationMethodDisableSmsSignInRequestBuilder extends BaseActionRequestBuilder<PhoneAuthenticationMethod> {

    /**
     * The request builder for this PhoneAuthenticationMethodDisableSmsSignIn
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public PhoneAuthenticationMethodDisableSmsSignInRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the PhoneAuthenticationMethodDisableSmsSignInRequest
     *
     * @param requestOptions the options for the request
     * @return the PhoneAuthenticationMethodDisableSmsSignInRequest instance
     */
    @Nonnull
    public PhoneAuthenticationMethodDisableSmsSignInRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the PhoneAuthenticationMethodDisableSmsSignInRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the PhoneAuthenticationMethodDisableSmsSignInRequest instance
     */
    @Nonnull
    public PhoneAuthenticationMethodDisableSmsSignInRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        final PhoneAuthenticationMethodDisableSmsSignInRequest request = new PhoneAuthenticationMethodDisableSmsSignInRequest(
                getRequestUrl(),
                getClient(),
                requestOptions);
        return request;
    }
}
