// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.MobileContainedApp;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Mobile Contained App Request.
 */
public class MobileContainedAppRequest extends BaseRequest<MobileContainedApp> {
	
    /**
     * The request for the MobileContainedApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public MobileContainedAppRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends MobileContainedApp> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the MobileContainedApp
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MobileContainedAppRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, MobileContainedApp.class);
    }

    /**
     * Gets the MobileContainedApp from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileContainedApp> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the MobileContainedApp from the service
     *
     * @return the MobileContainedApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileContainedApp get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileContainedApp> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public MobileContainedApp delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this MobileContainedApp with a source
     *
     * @param sourceMobileContainedApp the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileContainedApp> patchAsync(@Nonnull final MobileContainedApp sourceMobileContainedApp) {
        return sendAsync(HttpMethod.PATCH, sourceMobileContainedApp);
    }

    /**
     * Patches this MobileContainedApp with a source
     *
     * @param sourceMobileContainedApp the source object with updates
     * @return the updated MobileContainedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileContainedApp patch(@Nonnull final MobileContainedApp sourceMobileContainedApp) throws ClientException {
        return send(HttpMethod.PATCH, sourceMobileContainedApp);
    }

    /**
     * Creates a MobileContainedApp with a new object
     *
     * @param newMobileContainedApp the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileContainedApp> postAsync(@Nonnull final MobileContainedApp newMobileContainedApp) {
        return sendAsync(HttpMethod.POST, newMobileContainedApp);
    }

    /**
     * Creates a MobileContainedApp with a new object
     *
     * @param newMobileContainedApp the new object to create
     * @return the created MobileContainedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileContainedApp post(@Nonnull final MobileContainedApp newMobileContainedApp) throws ClientException {
        return send(HttpMethod.POST, newMobileContainedApp);
    }

    /**
     * Creates a MobileContainedApp with a new object
     *
     * @param newMobileContainedApp the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<MobileContainedApp> putAsync(@Nonnull final MobileContainedApp newMobileContainedApp) {
        return sendAsync(HttpMethod.PUT, newMobileContainedApp);
    }

    /**
     * Creates a MobileContainedApp with a new object
     *
     * @param newMobileContainedApp the object to create/update
     * @return the created MobileContainedApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public MobileContainedApp put(@Nonnull final MobileContainedApp newMobileContainedApp) throws ClientException {
        return send(HttpMethod.PUT, newMobileContainedApp);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public MobileContainedAppRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public MobileContainedAppRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

