// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.InferenceClassification;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Inference Classification Request.
 */
public class InferenceClassificationRequest extends BaseRequest<InferenceClassification> {
	
    /**
     * The request for the InferenceClassification
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public InferenceClassificationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, InferenceClassification.class);
    }

    /**
     * Gets the InferenceClassification from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassification> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the InferenceClassification from the service
     *
     * @return the InferenceClassification from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InferenceClassification get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassification> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public InferenceClassification delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this InferenceClassification with a source
     *
     * @param sourceInferenceClassification the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassification> patchAsync(@Nonnull final InferenceClassification sourceInferenceClassification) {
        return sendAsync(HttpMethod.PATCH, sourceInferenceClassification);
    }

    /**
     * Patches this InferenceClassification with a source
     *
     * @param sourceInferenceClassification the source object with updates
     * @return the updated InferenceClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InferenceClassification patch(@Nonnull final InferenceClassification sourceInferenceClassification) throws ClientException {
        return send(HttpMethod.PATCH, sourceInferenceClassification);
    }

    /**
     * Creates a InferenceClassification with a new object
     *
     * @param newInferenceClassification the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassification> postAsync(@Nonnull final InferenceClassification newInferenceClassification) {
        return sendAsync(HttpMethod.POST, newInferenceClassification);
    }

    /**
     * Creates a InferenceClassification with a new object
     *
     * @param newInferenceClassification the new object to create
     * @return the created InferenceClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InferenceClassification post(@Nonnull final InferenceClassification newInferenceClassification) throws ClientException {
        return send(HttpMethod.POST, newInferenceClassification);
    }

    /**
     * Creates a InferenceClassification with a new object
     *
     * @param newInferenceClassification the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassification> putAsync(@Nonnull final InferenceClassification newInferenceClassification) {
        return sendAsync(HttpMethod.PUT, newInferenceClassification);
    }

    /**
     * Creates a InferenceClassification with a new object
     *
     * @param newInferenceClassification the object to create/update
     * @return the created InferenceClassification
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InferenceClassification put(@Nonnull final InferenceClassification newInferenceClassification) throws ClientException {
        return send(HttpMethod.PUT, newInferenceClassification);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public InferenceClassificationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public InferenceClassificationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

