// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ImportedWindowsAutopilotDeviceIdentityUpload;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Imported Windows Autopilot Device Identity Upload Request.
 */
public class ImportedWindowsAutopilotDeviceIdentityUploadRequest extends BaseRequest<ImportedWindowsAutopilotDeviceIdentityUpload> {
	
    /**
     * The request for the ImportedWindowsAutopilotDeviceIdentityUpload
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ImportedWindowsAutopilotDeviceIdentityUploadRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ImportedWindowsAutopilotDeviceIdentityUpload.class);
    }

    /**
     * Gets the ImportedWindowsAutopilotDeviceIdentityUpload from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentityUpload> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ImportedWindowsAutopilotDeviceIdentityUpload from the service
     *
     * @return the ImportedWindowsAutopilotDeviceIdentityUpload from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentityUpload get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentityUpload> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentityUpload delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ImportedWindowsAutopilotDeviceIdentityUpload with a source
     *
     * @param sourceImportedWindowsAutopilotDeviceIdentityUpload the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentityUpload> patchAsync(@Nonnull final ImportedWindowsAutopilotDeviceIdentityUpload sourceImportedWindowsAutopilotDeviceIdentityUpload) {
        return sendAsync(HttpMethod.PATCH, sourceImportedWindowsAutopilotDeviceIdentityUpload);
    }

    /**
     * Patches this ImportedWindowsAutopilotDeviceIdentityUpload with a source
     *
     * @param sourceImportedWindowsAutopilotDeviceIdentityUpload the source object with updates
     * @return the updated ImportedWindowsAutopilotDeviceIdentityUpload
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentityUpload patch(@Nonnull final ImportedWindowsAutopilotDeviceIdentityUpload sourceImportedWindowsAutopilotDeviceIdentityUpload) throws ClientException {
        return send(HttpMethod.PATCH, sourceImportedWindowsAutopilotDeviceIdentityUpload);
    }

    /**
     * Creates a ImportedWindowsAutopilotDeviceIdentityUpload with a new object
     *
     * @param newImportedWindowsAutopilotDeviceIdentityUpload the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentityUpload> postAsync(@Nonnull final ImportedWindowsAutopilotDeviceIdentityUpload newImportedWindowsAutopilotDeviceIdentityUpload) {
        return sendAsync(HttpMethod.POST, newImportedWindowsAutopilotDeviceIdentityUpload);
    }

    /**
     * Creates a ImportedWindowsAutopilotDeviceIdentityUpload with a new object
     *
     * @param newImportedWindowsAutopilotDeviceIdentityUpload the new object to create
     * @return the created ImportedWindowsAutopilotDeviceIdentityUpload
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentityUpload post(@Nonnull final ImportedWindowsAutopilotDeviceIdentityUpload newImportedWindowsAutopilotDeviceIdentityUpload) throws ClientException {
        return send(HttpMethod.POST, newImportedWindowsAutopilotDeviceIdentityUpload);
    }

    /**
     * Creates a ImportedWindowsAutopilotDeviceIdentityUpload with a new object
     *
     * @param newImportedWindowsAutopilotDeviceIdentityUpload the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ImportedWindowsAutopilotDeviceIdentityUpload> putAsync(@Nonnull final ImportedWindowsAutopilotDeviceIdentityUpload newImportedWindowsAutopilotDeviceIdentityUpload) {
        return sendAsync(HttpMethod.PUT, newImportedWindowsAutopilotDeviceIdentityUpload);
    }

    /**
     * Creates a ImportedWindowsAutopilotDeviceIdentityUpload with a new object
     *
     * @param newImportedWindowsAutopilotDeviceIdentityUpload the object to create/update
     * @return the created ImportedWindowsAutopilotDeviceIdentityUpload
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ImportedWindowsAutopilotDeviceIdentityUpload put(@Nonnull final ImportedWindowsAutopilotDeviceIdentityUpload newImportedWindowsAutopilotDeviceIdentityUpload) throws ClientException {
        return send(HttpMethod.PUT, newImportedWindowsAutopilotDeviceIdentityUpload);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ImportedWindowsAutopilotDeviceIdentityUploadRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ImportedWindowsAutopilotDeviceIdentityUploadRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

