// Template Source: BaseMethodCollectionPage.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.DirectoryObject;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.DeltaCollectionPage;
import com.microsoft.graph.requests.DirectoryObjectDeltaCollectionRequestBuilder;
import com.microsoft.graph.requests.DirectoryObjectDeltaCollectionPage;
import com.microsoft.graph.requests.DirectoryObjectDeltaCollectionResponse;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Delta Collection Page.
 */
public class DirectoryObjectDeltaCollectionPage extends DeltaCollectionPage<DirectoryObject, DirectoryObjectDeltaCollectionRequestBuilder> {

    /**
     * A collection page for DirectoryObject.
     *
     * @param response The serialized DirectoryObjectDeltaCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public DirectoryObjectDeltaCollectionPage(@Nonnull final DirectoryObjectDeltaCollectionResponse response, @Nonnull final DirectoryObjectDeltaCollectionRequestBuilder builder) {
       super(response, builder);
    }

	/**
     * Creates the collection page for DirectoryObjectDelta
     *
     * @param pageContents       the contents of this page
     * @param nextRequestBuilder the request builder for the next page
     */
    public DirectoryObjectDeltaCollectionPage(@Nonnull final java.util.List<DirectoryObject> pageContents, @Nullable final DirectoryObjectDeltaCollectionRequestBuilder nextRequestBuilder) {
        super(pageContents, nextRequestBuilder);
    }
}
