// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AttachmentSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attachment Session Request.
 */
public class AttachmentSessionRequest extends BaseRequest<AttachmentSession> {
	
    /**
     * The request for the AttachmentSession
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AttachmentSessionRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AttachmentSession.class);
    }

    /**
     * Gets the AttachmentSession from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentSession> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AttachmentSession from the service
     *
     * @return the AttachmentSession from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttachmentSession get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentSession> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AttachmentSession delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AttachmentSession with a source
     *
     * @param sourceAttachmentSession the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentSession> patchAsync(@Nonnull final AttachmentSession sourceAttachmentSession) {
        return sendAsync(HttpMethod.PATCH, sourceAttachmentSession);
    }

    /**
     * Patches this AttachmentSession with a source
     *
     * @param sourceAttachmentSession the source object with updates
     * @return the updated AttachmentSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttachmentSession patch(@Nonnull final AttachmentSession sourceAttachmentSession) throws ClientException {
        return send(HttpMethod.PATCH, sourceAttachmentSession);
    }

    /**
     * Creates a AttachmentSession with a new object
     *
     * @param newAttachmentSession the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentSession> postAsync(@Nonnull final AttachmentSession newAttachmentSession) {
        return sendAsync(HttpMethod.POST, newAttachmentSession);
    }

    /**
     * Creates a AttachmentSession with a new object
     *
     * @param newAttachmentSession the new object to create
     * @return the created AttachmentSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttachmentSession post(@Nonnull final AttachmentSession newAttachmentSession) throws ClientException {
        return send(HttpMethod.POST, newAttachmentSession);
    }

    /**
     * Creates a AttachmentSession with a new object
     *
     * @param newAttachmentSession the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentSession> putAsync(@Nonnull final AttachmentSession newAttachmentSession) {
        return sendAsync(HttpMethod.PUT, newAttachmentSession);
    }

    /**
     * Creates a AttachmentSession with a new object
     *
     * @param newAttachmentSession the object to create/update
     * @return the created AttachmentSession
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttachmentSession put(@Nonnull final AttachmentSession newAttachmentSession) throws ClientException {
        return send(HttpMethod.PUT, newAttachmentSession);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AttachmentSessionRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AttachmentSessionRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

