// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AssociatedTeamInfo;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Associated Team Info Request.
 */
public class AssociatedTeamInfoRequest extends BaseRequest<AssociatedTeamInfo> {
	
    /**
     * The request for the AssociatedTeamInfo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AssociatedTeamInfoRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AssociatedTeamInfo.class);
    }

    /**
     * Gets the AssociatedTeamInfo from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AssociatedTeamInfo> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AssociatedTeamInfo from the service
     *
     * @return the AssociatedTeamInfo from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AssociatedTeamInfo get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AssociatedTeamInfo> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AssociatedTeamInfo delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AssociatedTeamInfo with a source
     *
     * @param sourceAssociatedTeamInfo the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AssociatedTeamInfo> patchAsync(@Nonnull final AssociatedTeamInfo sourceAssociatedTeamInfo) {
        return sendAsync(HttpMethod.PATCH, sourceAssociatedTeamInfo);
    }

    /**
     * Patches this AssociatedTeamInfo with a source
     *
     * @param sourceAssociatedTeamInfo the source object with updates
     * @return the updated AssociatedTeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AssociatedTeamInfo patch(@Nonnull final AssociatedTeamInfo sourceAssociatedTeamInfo) throws ClientException {
        return send(HttpMethod.PATCH, sourceAssociatedTeamInfo);
    }

    /**
     * Creates a AssociatedTeamInfo with a new object
     *
     * @param newAssociatedTeamInfo the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AssociatedTeamInfo> postAsync(@Nonnull final AssociatedTeamInfo newAssociatedTeamInfo) {
        return sendAsync(HttpMethod.POST, newAssociatedTeamInfo);
    }

    /**
     * Creates a AssociatedTeamInfo with a new object
     *
     * @param newAssociatedTeamInfo the new object to create
     * @return the created AssociatedTeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AssociatedTeamInfo post(@Nonnull final AssociatedTeamInfo newAssociatedTeamInfo) throws ClientException {
        return send(HttpMethod.POST, newAssociatedTeamInfo);
    }

    /**
     * Creates a AssociatedTeamInfo with a new object
     *
     * @param newAssociatedTeamInfo the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AssociatedTeamInfo> putAsync(@Nonnull final AssociatedTeamInfo newAssociatedTeamInfo) {
        return sendAsync(HttpMethod.PUT, newAssociatedTeamInfo);
    }

    /**
     * Creates a AssociatedTeamInfo with a new object
     *
     * @param newAssociatedTeamInfo the object to create/update
     * @return the created AssociatedTeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AssociatedTeamInfo put(@Nonnull final AssociatedTeamInfo newAssociatedTeamInfo) throws ClientException {
        return send(HttpMethod.PUT, newAssociatedTeamInfo);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AssociatedTeamInfoRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AssociatedTeamInfoRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

