// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AndroidWorkProfileCustomConfiguration;
import com.microsoft.graph.models.DeviceConfigurationAssignment;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Android Work Profile Custom Configuration Request.
 */
public class AndroidWorkProfileCustomConfigurationRequest extends BaseRequest<AndroidWorkProfileCustomConfiguration> {
	
    /**
     * The request for the AndroidWorkProfileCustomConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AndroidWorkProfileCustomConfigurationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AndroidWorkProfileCustomConfiguration.class);
    }

    /**
     * Gets the AndroidWorkProfileCustomConfiguration from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidWorkProfileCustomConfiguration> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AndroidWorkProfileCustomConfiguration from the service
     *
     * @return the AndroidWorkProfileCustomConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidWorkProfileCustomConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidWorkProfileCustomConfiguration> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AndroidWorkProfileCustomConfiguration delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AndroidWorkProfileCustomConfiguration with a source
     *
     * @param sourceAndroidWorkProfileCustomConfiguration the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidWorkProfileCustomConfiguration> patchAsync(@Nonnull final AndroidWorkProfileCustomConfiguration sourceAndroidWorkProfileCustomConfiguration) {
        return sendAsync(HttpMethod.PATCH, sourceAndroidWorkProfileCustomConfiguration);
    }

    /**
     * Patches this AndroidWorkProfileCustomConfiguration with a source
     *
     * @param sourceAndroidWorkProfileCustomConfiguration the source object with updates
     * @return the updated AndroidWorkProfileCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidWorkProfileCustomConfiguration patch(@Nonnull final AndroidWorkProfileCustomConfiguration sourceAndroidWorkProfileCustomConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceAndroidWorkProfileCustomConfiguration);
    }

    /**
     * Creates a AndroidWorkProfileCustomConfiguration with a new object
     *
     * @param newAndroidWorkProfileCustomConfiguration the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidWorkProfileCustomConfiguration> postAsync(@Nonnull final AndroidWorkProfileCustomConfiguration newAndroidWorkProfileCustomConfiguration) {
        return sendAsync(HttpMethod.POST, newAndroidWorkProfileCustomConfiguration);
    }

    /**
     * Creates a AndroidWorkProfileCustomConfiguration with a new object
     *
     * @param newAndroidWorkProfileCustomConfiguration the new object to create
     * @return the created AndroidWorkProfileCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidWorkProfileCustomConfiguration post(@Nonnull final AndroidWorkProfileCustomConfiguration newAndroidWorkProfileCustomConfiguration) throws ClientException {
        return send(HttpMethod.POST, newAndroidWorkProfileCustomConfiguration);
    }

    /**
     * Creates a AndroidWorkProfileCustomConfiguration with a new object
     *
     * @param newAndroidWorkProfileCustomConfiguration the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AndroidWorkProfileCustomConfiguration> putAsync(@Nonnull final AndroidWorkProfileCustomConfiguration newAndroidWorkProfileCustomConfiguration) {
        return sendAsync(HttpMethod.PUT, newAndroidWorkProfileCustomConfiguration);
    }

    /**
     * Creates a AndroidWorkProfileCustomConfiguration with a new object
     *
     * @param newAndroidWorkProfileCustomConfiguration the object to create/update
     * @return the created AndroidWorkProfileCustomConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AndroidWorkProfileCustomConfiguration put(@Nonnull final AndroidWorkProfileCustomConfiguration newAndroidWorkProfileCustomConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newAndroidWorkProfileCustomConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AndroidWorkProfileCustomConfigurationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AndroidWorkProfileCustomConfigurationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

