// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessReviewReviewer;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Review Reviewer Request.
 */
public class AccessReviewReviewerRequest extends BaseRequest<AccessReviewReviewer> {
	
    /**
     * The request for the AccessReviewReviewer
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessReviewReviewerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessReviewReviewer.class);
    }

    /**
     * Gets the AccessReviewReviewer from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewReviewer> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AccessReviewReviewer from the service
     *
     * @return the AccessReviewReviewer from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewReviewer get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewReviewer> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AccessReviewReviewer delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AccessReviewReviewer with a source
     *
     * @param sourceAccessReviewReviewer the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewReviewer> patchAsync(@Nonnull final AccessReviewReviewer sourceAccessReviewReviewer) {
        return sendAsync(HttpMethod.PATCH, sourceAccessReviewReviewer);
    }

    /**
     * Patches this AccessReviewReviewer with a source
     *
     * @param sourceAccessReviewReviewer the source object with updates
     * @return the updated AccessReviewReviewer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewReviewer patch(@Nonnull final AccessReviewReviewer sourceAccessReviewReviewer) throws ClientException {
        return send(HttpMethod.PATCH, sourceAccessReviewReviewer);
    }

    /**
     * Creates a AccessReviewReviewer with a new object
     *
     * @param newAccessReviewReviewer the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewReviewer> postAsync(@Nonnull final AccessReviewReviewer newAccessReviewReviewer) {
        return sendAsync(HttpMethod.POST, newAccessReviewReviewer);
    }

    /**
     * Creates a AccessReviewReviewer with a new object
     *
     * @param newAccessReviewReviewer the new object to create
     * @return the created AccessReviewReviewer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewReviewer post(@Nonnull final AccessReviewReviewer newAccessReviewReviewer) throws ClientException {
        return send(HttpMethod.POST, newAccessReviewReviewer);
    }

    /**
     * Creates a AccessReviewReviewer with a new object
     *
     * @param newAccessReviewReviewer the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AccessReviewReviewer> putAsync(@Nonnull final AccessReviewReviewer newAccessReviewReviewer) {
        return sendAsync(HttpMethod.PUT, newAccessReviewReviewer);
    }

    /**
     * Creates a AccessReviewReviewer with a new object
     *
     * @param newAccessReviewReviewer the object to create/update
     * @return the created AccessReviewReviewer
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AccessReviewReviewer put(@Nonnull final AccessReviewReviewer newAccessReviewReviewer) throws ClientException {
        return send(HttpMethod.PUT, newAccessReviewReviewer);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewReviewerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AccessReviewReviewerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

