// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.WindowsInformationProtectionDataRecoveryCertificate;
import com.microsoft.graph.models.WindowsInformationProtectionEnforcementLevel;
import com.microsoft.graph.models.WindowsInformationProtectionResourceCollection;
import com.microsoft.graph.models.WindowsInformationProtectionIPRangeCollection;
import com.microsoft.graph.models.WindowsInformationProtectionProxiedDomainCollection;
import com.microsoft.graph.models.WindowsInformationProtectionApp;
import com.microsoft.graph.models.ManagedAppPolicy;
import com.microsoft.graph.requests.TargetedManagedAppPolicyAssignmentCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Information Protection.
 */
public class WindowsInformationProtection extends ManagedAppPolicy implements IJsonBackedObject {


    /**
     * The Azure Rights Management Services Allowed.
     * Specifies whether to allow Azure RMS encryption for WIP
     */
    @SerializedName(value = "azureRightsManagementServicesAllowed", alternate = {"AzureRightsManagementServicesAllowed"})
    @Expose
	@Nullable
    public Boolean azureRightsManagementServicesAllowed;

    /**
     * The Data Recovery Certificate.
     * Specifies a recovery certificate that can be used for data recovery of encrypted files. This is the same as the data recovery agent(DRA) certificate for encrypting file system(EFS)
     */
    @SerializedName(value = "dataRecoveryCertificate", alternate = {"DataRecoveryCertificate"})
    @Expose
	@Nullable
    public WindowsInformationProtectionDataRecoveryCertificate dataRecoveryCertificate;

    /**
     * The Enforcement Level.
     * WIP enforcement level.See the Enum definition for supported values. Possible values are: noProtection, encryptAndAuditOnly, encryptAuditAndPrompt, encryptAuditAndBlock.
     */
    @SerializedName(value = "enforcementLevel", alternate = {"EnforcementLevel"})
    @Expose
	@Nullable
    public WindowsInformationProtectionEnforcementLevel enforcementLevel;

    /**
     * The Enterprise Domain.
     * Primary enterprise domain
     */
    @SerializedName(value = "enterpriseDomain", alternate = {"EnterpriseDomain"})
    @Expose
	@Nullable
    public String enterpriseDomain;

    /**
     * The Enterprise Internal Proxy Servers.
     * This is the comma-separated list of internal proxy servers. For example, '157.54.14.28, 157.54.11.118, 10.202.14.167, 157.53.14.163, 157.69.210.59'. These proxies have been configured by the admin to connect to specific resources on the Internet. They are considered to be enterprise network locations. The proxies are only leveraged in configuring the EnterpriseProxiedDomains policy to force traffic to the matched domains through these proxies
     */
    @SerializedName(value = "enterpriseInternalProxyServers", alternate = {"EnterpriseInternalProxyServers"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionResourceCollection> enterpriseInternalProxyServers;

    /**
     * The Enterprise IPRanges.
     * Sets the enterprise IP ranges that define the computers in the enterprise network. Data that comes from those computers will be considered part of the enterprise and protected. These locations will be considered a safe destination for enterprise data to be shared to
     */
    @SerializedName(value = "enterpriseIPRanges", alternate = {"EnterpriseIPRanges"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionIPRangeCollection> enterpriseIPRanges;

    /**
     * The Enterprise IPRanges Are Authoritative.
     * Boolean value that tells the client to accept the configured list and not to use heuristics to attempt to find other subnets. Default is false
     */
    @SerializedName(value = "enterpriseIPRangesAreAuthoritative", alternate = {"EnterpriseIPRangesAreAuthoritative"})
    @Expose
	@Nullable
    public Boolean enterpriseIPRangesAreAuthoritative;

    /**
     * The Enterprise Network Domain Names.
     * This is the list of domains that comprise the boundaries of the enterprise. Data from one of these domains that is sent to a device will be considered enterprise data and protected These locations will be considered a safe destination for enterprise data to be shared to
     */
    @SerializedName(value = "enterpriseNetworkDomainNames", alternate = {"EnterpriseNetworkDomainNames"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionResourceCollection> enterpriseNetworkDomainNames;

    /**
     * The Enterprise Protected Domain Names.
     * List of enterprise domains to be protected
     */
    @SerializedName(value = "enterpriseProtectedDomainNames", alternate = {"EnterpriseProtectedDomainNames"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionResourceCollection> enterpriseProtectedDomainNames;

    /**
     * The Enterprise Proxied Domains.
     * Contains a list of Enterprise resource domains hosted in the cloud that need to be protected. Connections to these resources are considered enterprise data. If a proxy is paired with a cloud resource, traffic to the cloud resource will be routed through the enterprise network via the denoted proxy server (on Port 80). A proxy server used for this purpose must also be configured using the EnterpriseInternalProxyServers policy
     */
    @SerializedName(value = "enterpriseProxiedDomains", alternate = {"EnterpriseProxiedDomains"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionProxiedDomainCollection> enterpriseProxiedDomains;

    /**
     * The Enterprise Proxy Servers.
     * This is a list of proxy servers. Any server not on this list is considered non-enterprise
     */
    @SerializedName(value = "enterpriseProxyServers", alternate = {"EnterpriseProxyServers"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionResourceCollection> enterpriseProxyServers;

    /**
     * The Enterprise Proxy Servers Are Authoritative.
     * Boolean value that tells the client to accept the configured list of proxies and not try to detect other work proxies. Default is false
     */
    @SerializedName(value = "enterpriseProxyServersAreAuthoritative", alternate = {"EnterpriseProxyServersAreAuthoritative"})
    @Expose
	@Nullable
    public Boolean enterpriseProxyServersAreAuthoritative;

    /**
     * The Exempt Apps.
     * Exempt applications can also access enterprise data, but the data handled by those applications are not protected. This is because some critical enterprise applications may have compatibility problems with encrypted data.
     */
    @SerializedName(value = "exemptApps", alternate = {"ExemptApps"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionApp> exemptApps;

    /**
     * The Icons Visible.
     * Determines whether overlays are added to icons for WIP protected files in Explorer and enterprise only app tiles in the Start menu. Starting in Windows 10, version 1703 this setting also configures the visibility of the WIP icon in the title bar of a WIP-protected app
     */
    @SerializedName(value = "iconsVisible", alternate = {"IconsVisible"})
    @Expose
	@Nullable
    public Boolean iconsVisible;

    /**
     * The Indexing Encrypted Stores Or Items Blocked.
     * This switch is for the Windows Search Indexer, to allow or disallow indexing of items
     */
    @SerializedName(value = "indexingEncryptedStoresOrItemsBlocked", alternate = {"IndexingEncryptedStoresOrItemsBlocked"})
    @Expose
	@Nullable
    public Boolean indexingEncryptedStoresOrItemsBlocked;

    /**
     * The Is Assigned.
     * Indicates if the policy is deployed to any inclusion groups or not.
     */
    @SerializedName(value = "isAssigned", alternate = {"IsAssigned"})
    @Expose
	@Nullable
    public Boolean isAssigned;

    /**
     * The Neutral Domain Resources.
     * List of domain names that can used for work or personal resource
     */
    @SerializedName(value = "neutralDomainResources", alternate = {"NeutralDomainResources"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionResourceCollection> neutralDomainResources;

    /**
     * The Protected Apps.
     * Protected applications can access enterprise data and the data handled by those applications are protected with encryption
     */
    @SerializedName(value = "protectedApps", alternate = {"ProtectedApps"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionApp> protectedApps;

    /**
     * The Protection Under Lock Config Required.
     * Specifies whether the protection under lock feature (also known as encrypt under pin) should be configured
     */
    @SerializedName(value = "protectionUnderLockConfigRequired", alternate = {"ProtectionUnderLockConfigRequired"})
    @Expose
	@Nullable
    public Boolean protectionUnderLockConfigRequired;

    /**
     * The Revoke On Unenroll Disabled.
     * This policy controls whether to revoke the WIP keys when a device unenrolls from the management service. If set to 1 (Don't revoke keys), the keys will not be revoked and the user will continue to have access to protected files after unenrollment. If the keys are not revoked, there will be no revoked file cleanup subsequently.
     */
    @SerializedName(value = "revokeOnUnenrollDisabled", alternate = {"RevokeOnUnenrollDisabled"})
    @Expose
	@Nullable
    public Boolean revokeOnUnenrollDisabled;

    /**
     * The Rights Management Services Template Id.
     * TemplateID GUID to use for RMS encryption. The RMS template allows the IT admin to configure the details about who has access to RMS-protected file and how long they have access
     */
    @SerializedName(value = "rightsManagementServicesTemplateId", alternate = {"RightsManagementServicesTemplateId"})
    @Expose
	@Nullable
    public java.util.UUID rightsManagementServicesTemplateId;

    /**
     * The Smb Auto Encrypted File Extensions.
     * Specifies a list of file extensions, so that files with these extensions are encrypted when copying from an SMB share within the corporate boundary
     */
    @SerializedName(value = "smbAutoEncryptedFileExtensions", alternate = {"SmbAutoEncryptedFileExtensions"})
    @Expose
	@Nullable
    public java.util.List<WindowsInformationProtectionResourceCollection> smbAutoEncryptedFileExtensions;

    /**
     * The Assignments.
     * Navigation property to list of security groups targeted for policy.
     */
    @SerializedName(value = "assignments", alternate = {"Assignments"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.TargetedManagedAppPolicyAssignmentCollectionPage assignments;

    /**
     * The Exempt App Locker Files.
     * Another way to input exempt apps through xml files
     */
    @SerializedName(value = "exemptAppLockerFiles", alternate = {"ExemptAppLockerFiles"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.WindowsInformationProtectionAppLockerFileCollectionPage exemptAppLockerFiles;

    /**
     * The Protected App Locker Files.
     * Another way to input protected apps through xml files
     */
    @SerializedName(value = "protectedAppLockerFiles", alternate = {"ProtectedAppLockerFiles"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.WindowsInformationProtectionAppLockerFileCollectionPage protectedAppLockerFiles;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("assignments")) {
            assignments = serializer.deserializeObject(json.get("assignments"), com.microsoft.graph.requests.TargetedManagedAppPolicyAssignmentCollectionPage.class);
        }

        if (json.has("exemptAppLockerFiles")) {
            exemptAppLockerFiles = serializer.deserializeObject(json.get("exemptAppLockerFiles"), com.microsoft.graph.requests.WindowsInformationProtectionAppLockerFileCollectionPage.class);
        }

        if (json.has("protectedAppLockerFiles")) {
            protectedAppLockerFiles = serializer.deserializeObject(json.get("protectedAppLockerFiles"), com.microsoft.graph.requests.WindowsInformationProtectionAppLockerFileCollectionPage.class);
        }
    }
}
