// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.AssociatedTeamInfoCollectionPage;
import com.microsoft.graph.requests.UserScopeTeamsAppInstallationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Teamwork.
 */
public class UserTeamwork extends Entity implements IJsonBackedObject {


    /**
     * The Associated Teams.
     * The list of associatedTeamInfo objects that a user is associated with.
     */
    @SerializedName(value = "associatedTeams", alternate = {"AssociatedTeams"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.AssociatedTeamInfoCollectionPage associatedTeams;

    /**
     * The Installed Apps.
     * The apps installed in the personal scope of this user.
     */
    @SerializedName(value = "installedApps", alternate = {"InstalledApps"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.UserScopeTeamsAppInstallationCollectionPage installedApps;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("associatedTeams")) {
            associatedTeams = serializer.deserializeObject(json.get("associatedTeams"), com.microsoft.graph.requests.AssociatedTeamInfoCollectionPage.class);
        }

        if (json.has("installedApps")) {
            installedApps = serializer.deserializeObject(json.get("installedApps"), com.microsoft.graph.requests.UserScopeTeamsAppInstallationCollectionPage.class);
        }
    }
}
