// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.TeamworkTagType;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.TeamworkTagMemberCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Teamwork Tag.
 */
public class TeamworkTag extends Entity implements IJsonBackedObject {


    /**
     * The Description.
     * The description of the tag as it will appear to the user in Microsoft Teams. A teamworkTag can't have more than 200 teamworkTagMembers.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The name of the tag as it will appear to the user in Microsoft Teams.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Member Count.
     * The number of users assigned to the tag.
     */
    @SerializedName(value = "memberCount", alternate = {"MemberCount"})
    @Expose
	@Nullable
    public Integer memberCount;

    /**
     * The Tag Type.
     * The type of the tag. Default is standard.
     */
    @SerializedName(value = "tagType", alternate = {"TagType"})
    @Expose
	@Nullable
    public TeamworkTagType tagType;

    /**
     * The Team Id.
     * ID of the team in which the tag is defined.
     */
    @SerializedName(value = "teamId", alternate = {"TeamId"})
    @Expose
	@Nullable
    public String teamId;

    /**
     * The Members.
     * Users assigned to the tag.
     */
    @SerializedName(value = "members", alternate = {"Members"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.TeamworkTagMemberCollectionPage members;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("members")) {
            members = serializer.deserializeObject(json.get("members"), com.microsoft.graph.requests.TeamworkTagMemberCollectionPage.class);
        }
    }
}
