// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ActivityType;
import com.microsoft.graph.models.RiskDetectionTimingType;
import com.microsoft.graph.models.SignInLocation;
import com.microsoft.graph.models.RiskDetail;
import com.microsoft.graph.models.RiskLevel;
import com.microsoft.graph.models.RiskState;
import com.microsoft.graph.models.TokenIssuerType;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Service Principal Risk Detection.
 */
public class ServicePrincipalRiskDetection extends Entity implements IJsonBackedObject {


    /**
     * The Activity.
     * Indicates the activity type the detected risk is linked to.  The possible values are: signin, servicePrincipal. Note that you must use the Prefer: include-unknown-enum-members request header to get the following value(s) in this evolvable enum: servicePrincipal.
     */
    @SerializedName(value = "activity", alternate = {"Activity"})
    @Expose
	@Nullable
    public ActivityType activity;

    /**
     * The Activity Date Time.
     * Date and time when the risky activity occurred. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z
     */
    @SerializedName(value = "activityDateTime", alternate = {"ActivityDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime activityDateTime;

    /**
     * The Additional Info.
     * Additional information associated with the risk detection. This string value is represented as a JSON object with the quotations escaped.
     */
    @SerializedName(value = "additionalInfo", alternate = {"AdditionalInfo"})
    @Expose
	@Nullable
    public String additionalInfo;

    /**
     * The App Id.
     * The unique identifier for the associated application.
     */
    @SerializedName(value = "appId", alternate = {"AppId"})
    @Expose
	@Nullable
    public String appId;

    /**
     * The Correlation Id.
     * Correlation ID of the sign-in activity associated with the risk detection. This property is null if the risk detection is not associated with a sign-in activity.
     */
    @SerializedName(value = "correlationId", alternate = {"CorrelationId"})
    @Expose
	@Nullable
    public String correlationId;

    /**
     * The Detected Date Time.
     * Date and time when the risk was detected. The DateTimeOffset type represents date and time information using ISO 8601 format and is always in UTC time. For example, midnight UTC on Jan 1, 2014 is 2014-01-01T00:00:00Z.
     */
    @SerializedName(value = "detectedDateTime", alternate = {"DetectedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime detectedDateTime;

    /**
     * The Detection Timing Type.
     * Timing of the detected risk , whether real-time or offline. The possible values are: notDefined, realtime, nearRealtime, offline, unknownFutureValue.
     */
    @SerializedName(value = "detectionTimingType", alternate = {"DetectionTimingType"})
    @Expose
	@Nullable
    public RiskDetectionTimingType detectionTimingType;

    /**
     * The Ip Address.
     * Provides the IP address of the client from where the risk occurred.
     */
    @SerializedName(value = "ipAddress", alternate = {"IpAddress"})
    @Expose
	@Nullable
    public String ipAddress;

    /**
     * The Key Ids.
     * The unique identifier for the key credential associated with the risk detection.
     */
    @SerializedName(value = "keyIds", alternate = {"KeyIds"})
    @Expose
	@Nullable
    public java.util.List<String> keyIds;

    /**
     * The Last Updated Date Time.
     * Date and time when the risk detection was last updated.
     */
    @SerializedName(value = "lastUpdatedDateTime", alternate = {"LastUpdatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastUpdatedDateTime;

    /**
     * The Location.
     * Location from where the sign-in was initiated.
     */
    @SerializedName(value = "location", alternate = {"Location"})
    @Expose
	@Nullable
    public SignInLocation location;

    /**
     * The Request Id.
     * Request identifier of the sign-in activity associated with the risk detection. This property is null if the risk detection is not associated with a sign-in activity. Supports $filter (eq).
     */
    @SerializedName(value = "requestId", alternate = {"RequestId"})
    @Expose
	@Nullable
    public String requestId;

    /**
     * The Risk Detail.
     * Details of the detected risk. Note: Details for this property are only available for Workload Identities Premium customers. Events in tenants without this license will be returned hidden. The possible values are: none, hidden, adminConfirmedServicePrincipalCompromised, adminDismissedAllRiskForServicePrincipal. Note that you must use the Prefer: include-unknown-enum-members request header to get the following value(s) in this evolvable enum: adminConfirmedServicePrincipalCompromised , adminDismissedAllRiskForServicePrincipal.
     */
    @SerializedName(value = "riskDetail", alternate = {"RiskDetail"})
    @Expose
	@Nullable
    public RiskDetail riskDetail;

    /**
     * The Risk Event Type.
     * The type of risk event detected. The possible values are: investigationsThreatIntelligence, generic, adminConfirmedServicePrincipalCompromised, suspiciousSignins, leakedCredentials, anomalousServicePrincipalActivity, maliciousApplication, suspiciousApplication.
     */
    @SerializedName(value = "riskEventType", alternate = {"RiskEventType"})
    @Expose
	@Nullable
    public String riskEventType;

    /**
     * The Risk Level.
     * Level of the detected risk. Note: Details for this property are only available for Workload Identities Premium customers. Events in tenants without this license will be returned hidden. The possible values are: low, medium, high, hidden, none.
     */
    @SerializedName(value = "riskLevel", alternate = {"RiskLevel"})
    @Expose
	@Nullable
    public RiskLevel riskLevel;

    /**
     * The Risk State.
     * The state of a detected risky service principal or sign-in activity. The possible values are: none, dismissed, atRisk, confirmedCompromised.
     */
    @SerializedName(value = "riskState", alternate = {"RiskState"})
    @Expose
	@Nullable
    public RiskState riskState;

    /**
     * The Service Principal Display Name.
     * The display name for the service principal.
     */
    @SerializedName(value = "servicePrincipalDisplayName", alternate = {"ServicePrincipalDisplayName"})
    @Expose
	@Nullable
    public String servicePrincipalDisplayName;

    /**
     * The Service Principal Id.
     * The unique identifier for the service principal. Supports $filter (eq).
     */
    @SerializedName(value = "servicePrincipalId", alternate = {"ServicePrincipalId"})
    @Expose
	@Nullable
    public String servicePrincipalId;

    /**
     * The Source.
     * Source of the risk detection. For example, identityProtection.
     */
    @SerializedName(value = "source", alternate = {"Source"})
    @Expose
	@Nullable
    public String source;

    /**
     * The Token Issuer Type.
     * Indicates the type of token issuer for the detected sign-in risk. The possible values are: AzureAD.
     */
    @SerializedName(value = "tokenIssuerType", alternate = {"TokenIssuerType"})
    @Expose
	@Nullable
    public TokenIssuerType tokenIssuerType;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
