// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.security.models.HuntingQueryResults;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Security Run Hunting Query Parameter Set.
 */
public class SecurityRunHuntingQueryParameterSet {
    /**
     * The query.
     * 
     */
    @SerializedName(value = "query", alternate = {"Query"})
    @Expose
	@Nullable
    public String query;


    /**
     * Instiaciates a new SecurityRunHuntingQueryParameterSet
     */
    public SecurityRunHuntingQueryParameterSet() {}
    /**
     * Instiaciates a new SecurityRunHuntingQueryParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected SecurityRunHuntingQueryParameterSet(@Nonnull final SecurityRunHuntingQueryParameterSetBuilder builder) {
        this.query = builder.query;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static SecurityRunHuntingQueryParameterSetBuilder newBuilder() {
        return new SecurityRunHuntingQueryParameterSetBuilder();
    }
    /**
     * Fluent builder for the SecurityRunHuntingQueryParameterSet
     */
    public static final class SecurityRunHuntingQueryParameterSetBuilder {
        /**
         * The query parameter value
         */
        @Nullable
        protected String query;
        /**
         * Sets the Query
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public SecurityRunHuntingQueryParameterSetBuilder withQuery(@Nullable final String val) {
            this.query = val;
            return this;
        }
        /**
         * Instanciates a new SecurityRunHuntingQueryParameterSetBuilder
         */
        @Nullable
        protected SecurityRunHuntingQueryParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public SecurityRunHuntingQueryParameterSet build() {
            return new SecurityRunHuntingQueryParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.query != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("query", query));
        }
        return result;
    }
}
