// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.MobileApp;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Iosi Pad OSWeb Clip.
 */
public class IosiPadOSWebClip extends MobileApp implements IJsonBackedObject {


    /**
     * The App Url.
     * Indicates iOS/iPadOS web clip app URL. Example: 'https://www.contoso.com'
     */
    @SerializedName(value = "appUrl", alternate = {"AppUrl"})
    @Expose
	@Nullable
    public String appUrl;

    /**
     * The Use Managed Browser.
     * Whether or not to use managed browser. When TRUE, the app will be required to be opened in Microsoft Edge. When FALSE, the app will not be required to be opened in Microsoft Edge. By default, this property is set to FALSE.
     */
    @SerializedName(value = "useManagedBrowser", alternate = {"UseManagedBrowser"})
    @Expose
	@Nullable
    public Boolean useManagedBrowser;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
