// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.ConditionalAccessRoot;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.IdentityApiConnectorCollectionPage;
import com.microsoft.graph.requests.B2xIdentityUserFlowCollectionPage;
import com.microsoft.graph.requests.IdentityProviderBaseCollectionPage;
import com.microsoft.graph.requests.IdentityUserFlowAttributeCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Identity Container.
 */
public class IdentityContainer extends Entity implements IJsonBackedObject {


    /**
     * The Api Connectors.
     * Represents entry point for API connectors.
     */
    @SerializedName(value = "apiConnectors", alternate = {"ApiConnectors"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.IdentityApiConnectorCollectionPage apiConnectors;

    /**
     * The B2x User Flows.
     * Represents entry point for B2X/self-service sign-up identity userflows.
     */
    @SerializedName(value = "b2xUserFlows", alternate = {"B2xUserFlows"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.B2xIdentityUserFlowCollectionPage b2xUserFlows;

    /**
     * The Identity Providers.
     * 
     */
    @SerializedName(value = "identityProviders", alternate = {"IdentityProviders"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.IdentityProviderBaseCollectionPage identityProviders;

    /**
     * The User Flow Attributes.
     * Represents entry point for identity userflow attributes.
     */
    @SerializedName(value = "userFlowAttributes", alternate = {"UserFlowAttributes"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.IdentityUserFlowAttributeCollectionPage userFlowAttributes;

    /**
     * The Conditional Access.
     * the entry point for the Conditional Access (CA) object model.
     */
    @SerializedName(value = "conditionalAccess", alternate = {"ConditionalAccess"})
    @Expose
	@Nullable
    public ConditionalAccessRoot conditionalAccess;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("apiConnectors")) {
            apiConnectors = serializer.deserializeObject(json.get("apiConnectors"), com.microsoft.graph.requests.IdentityApiConnectorCollectionPage.class);
        }

        if (json.has("b2xUserFlows")) {
            b2xUserFlows = serializer.deserializeObject(json.get("b2xUserFlows"), com.microsoft.graph.requests.B2xIdentityUserFlowCollectionPage.class);
        }

        if (json.has("identityProviders")) {
            identityProviders = serializer.deserializeObject(json.get("identityProviders"), com.microsoft.graph.requests.IdentityProviderBaseCollectionPage.class);
        }

        if (json.has("userFlowAttributes")) {
            userFlowAttributes = serializer.deserializeObject(json.get("userFlowAttributes"), com.microsoft.graph.requests.IdentityUserFlowAttributeCollectionPage.class);
        }
    }
}
