// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.DelegatedAdminRelationshipRequestAction;
import com.microsoft.graph.models.DelegatedAdminRelationshipRequestStatus;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Delegated Admin Relationship Request.
 */
public class DelegatedAdminRelationshipRequest extends Entity implements IJsonBackedObject {


    /**
     * The Action.
     * The action to be performed on the delegated admin relationship.
     */
    @SerializedName(value = "action", alternate = {"Action"})
    @Expose
	@Nullable
    public DelegatedAdminRelationshipRequestAction action;

    /**
     * The Created Date Time.
     * The date and time in ISO 8601 format and in UTC time when the relationship request was created. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Last Modified Date Time.
     * The date and time in ISO 8601 format and UTC time when this relationship request was last modified. Read-only.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Status.
     * The status of the request. Read-only. The possible values are: created, pending, succeeded, failed, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public DelegatedAdminRelationshipRequestStatus status;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
