// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Cross Tenant Access Policy Inbound Trust.
 */
public class CrossTenantAccessPolicyInboundTrust implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Is Compliant Device Accepted.
     * Specifies whether compliant devices from external Azure AD organizations are trusted.
     */
    @SerializedName(value = "isCompliantDeviceAccepted", alternate = {"IsCompliantDeviceAccepted"})
    @Expose
	@Nullable
    public Boolean isCompliantDeviceAccepted;

    /**
     * The Is Hybrid Azure ADJoined Device Accepted.
     * Specifies whether hybrid Azure AD joined devices from external Azure AD organizations are trusted.
     */
    @SerializedName(value = "isHybridAzureADJoinedDeviceAccepted", alternate = {"IsHybridAzureADJoinedDeviceAccepted"})
    @Expose
	@Nullable
    public Boolean isHybridAzureADJoinedDeviceAccepted;

    /**
     * The Is Mfa Accepted.
     * Specifies whether MFA from external Azure AD organizations is trusted.
     */
    @SerializedName(value = "isMfaAccepted", alternate = {"IsMfaAccepted"})
    @Expose
	@Nullable
    public Boolean isMfaAccepted;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
