// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.models.ConditionalAccessPolicyDetail;
import com.microsoft.graph.models.TemplateScenarios;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Template.
 */
public class ConditionalAccessTemplate extends Entity implements IJsonBackedObject {


    /**
     * The Description.
     * The user-friendly name of the template.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Details.
     * Complete list of policy details specific to the template. This property contains the JSON of policy settings for configuring a Conditional Access policy.
     */
    @SerializedName(value = "details", alternate = {"Details"})
    @Expose
	@Nullable
    public ConditionalAccessPolicyDetail details;

    /**
     * The Name.
     * The user-friendly name of the template.
     */
    @SerializedName(value = "name", alternate = {"Name"})
    @Expose
	@Nullable
    public String name;

    /**
     * The Scenarios.
     * List of conditional access scenarios that the template is recommended for. The possible values are: new, secureFoundation, zeroTrust, remoteWork, protectAdmins, emergingThreats, unknownFutureValue. This is a multi-valued enum. Supports $filter (has).
     */
    @SerializedName(value = "scenarios", alternate = {"Scenarios"})
    @Expose
	@Nullable
    public EnumSet<TemplateScenarios> scenarios;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
