// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Certification.
 */
public class Certification implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Certification Details Url.
     * URL that shows certification details for the application.
     */
    @SerializedName(value = "certificationDetailsUrl", alternate = {"CertificationDetailsUrl"})
    @Expose
	@Nullable
    public String certificationDetailsUrl;

    /**
     * The Certification Expiration Date Time.
     * The timestamp when the current certification for the application will expire.
     */
    @SerializedName(value = "certificationExpirationDateTime", alternate = {"CertificationExpirationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime certificationExpirationDateTime;

    /**
     * The Is Certified By Microsoft.
     * Indicates whether the application is certified by Microsoft.
     */
    @SerializedName(value = "isCertifiedByMicrosoft", alternate = {"IsCertifiedByMicrosoft"})
    @Expose
	@Nullable
    public Boolean isCertifiedByMicrosoft;

    /**
     * The Is Publisher Attested.
     * Indicates whether the application has been self-attested by the application developer or the publisher.
     */
    @SerializedName(value = "isPublisherAttested", alternate = {"IsPublisherAttested"})
    @Expose
	@Nullable
    public Boolean isPublisherAttested;

    /**
     * The Last Certification Date Time.
     * The timestamp when the certification for the application was most recently added or updated.
     */
    @SerializedName(value = "lastCertificationDateTime", alternate = {"LastCertificationDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastCertificationDateTime;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
