// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.BrowserSiteListStatus;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.requests.BrowserSharedCookieCollectionPage;
import com.microsoft.graph.requests.BrowserSiteCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Browser Site List.
 */
public class BrowserSiteList extends Entity implements IJsonBackedObject {


    /**
     * The Description.
     * The description of the site list.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Display Name.
     * The name of the site list.
     */
    @SerializedName(value = "displayName", alternate = {"DisplayName"})
    @Expose
	@Nullable
    public String displayName;

    /**
     * The Last Modified By.
     * The user who last modified the site list.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public IdentitySet lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * The date and time when the site list was last modified.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Published By.
     * The user who published the site list.
     */
    @SerializedName(value = "publishedBy", alternate = {"PublishedBy"})
    @Expose
	@Nullable
    public IdentitySet publishedBy;

    /**
     * The Published Date Time.
     * The date and time when the site list was published.
     */
    @SerializedName(value = "publishedDateTime", alternate = {"PublishedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime publishedDateTime;

    /**
     * The Revision.
     * The current revision of the site list.
     */
    @SerializedName(value = "revision", alternate = {"Revision"})
    @Expose
	@Nullable
    public String revision;

    /**
     * The Status.
     * The current status of the site list. The possible values are: draft, published, pending, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public BrowserSiteListStatus status;

    /**
     * The Shared Cookies.
     * A collection of shared cookies defined for the site list.
     */
    @SerializedName(value = "sharedCookies", alternate = {"SharedCookies"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.BrowserSharedCookieCollectionPage sharedCookies;

    /**
     * The Sites.
     * A collection of sites defined for the site list.
     */
    @SerializedName(value = "sites", alternate = {"Sites"})
    @Expose
	@Nullable
    public com.microsoft.graph.requests.BrowserSiteCollectionPage sites;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("sharedCookies")) {
            sharedCookies = serializer.deserializeObject(json.get("sharedCookies"), com.microsoft.graph.requests.BrowserSharedCookieCollectionPage.class);
        }

        if (json.has("sites")) {
            sites = serializer.deserializeObject(json.get("sites"), com.microsoft.graph.requests.BrowserSiteCollectionPage.class);
        }
    }
}
