// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.BrowserSiteCompatibilityMode;
import com.microsoft.graph.models.BrowserSiteHistory;
import com.microsoft.graph.models.IdentitySet;
import com.microsoft.graph.models.BrowserSiteMergeType;
import com.microsoft.graph.models.BrowserSiteStatus;
import com.microsoft.graph.models.BrowserSiteTargetEnvironment;
import com.microsoft.graph.models.Entity;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Browser Site.
 */
public class BrowserSite extends Entity implements IJsonBackedObject {


    /**
     * The Allow Redirect.
     * Controls the behavior of redirected sites. If true, indicates that the site will open in Internet Explorer 11 or Microsoft Edge even if the site is navigated to as part of a HTTP or meta refresh redirection chain.
     */
    @SerializedName(value = "allowRedirect", alternate = {"AllowRedirect"})
    @Expose
	@Nullable
    public Boolean allowRedirect;

    /**
     * The Comment.
     * The comment for the site.
     */
    @SerializedName(value = "comment", alternate = {"Comment"})
    @Expose
	@Nullable
    public String comment;

    /**
     * The Compatibility Mode.
     * Controls what compatibility setting is used for specific sites or domains. The possible values are: default, internetExplorer8Enterprise, internetExplorer7Enterprise, internetExplorer11, internetExplorer10, internetExplorer9, internetExplorer8, internetExplorer7, internetExplorer5, unknownFutureValue.
     */
    @SerializedName(value = "compatibilityMode", alternate = {"CompatibilityMode"})
    @Expose
	@Nullable
    public BrowserSiteCompatibilityMode compatibilityMode;

    /**
     * The Created Date Time.
     * The date and time when the site was created.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Deleted Date Time.
     * The date and time when the site was deleted.
     */
    @SerializedName(value = "deletedDateTime", alternate = {"DeletedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime deletedDateTime;

    /**
     * The History.
     * The history of modifications applied to the site.
     */
    @SerializedName(value = "history", alternate = {"History"})
    @Expose
	@Nullable
    public java.util.List<BrowserSiteHistory> history;

    /**
     * The Last Modified By.
     * The user who last modified the site.
     */
    @SerializedName(value = "lastModifiedBy", alternate = {"LastModifiedBy"})
    @Expose
	@Nullable
    public IdentitySet lastModifiedBy;

    /**
     * The Last Modified Date Time.
     * The date and time when the site was last modified.
     */
    @SerializedName(value = "lastModifiedDateTime", alternate = {"LastModifiedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime lastModifiedDateTime;

    /**
     * The Merge Type.
     * The merge type of the site. The possible values are: noMerge, default, unknownFutureValue.
     */
    @SerializedName(value = "mergeType", alternate = {"MergeType"})
    @Expose
	@Nullable
    public BrowserSiteMergeType mergeType;

    /**
     * The Status.
     * Indicates the status of the site. The possible values are: published, pendingAdd, pendingEdit, pendingDelete, unknownFutureValue.
     */
    @SerializedName(value = "status", alternate = {"Status"})
    @Expose
	@Nullable
    public BrowserSiteStatus status;

    /**
     * The Target Environment.
     * The target environment that the site should open in. The possible values are: internetExplorerMode, internetExplorer11, microsoftEdge, configurable, none, unknownFutureValue.Prior to June 15, 2022, the internetExplorer11 option would allow opening a site in the Internet Explorer 11 (IE11) desktop application. Following the retirement of IE11 on June 15, 2022, the internetExplorer11 option will no longer open an IE11 window and will instead behave the same as the internetExplorerMode option.
     */
    @SerializedName(value = "targetEnvironment", alternate = {"TargetEnvironment"})
    @Expose
	@Nullable
    public BrowserSiteTargetEnvironment targetEnvironment;

    /**
     * The Web Url.
     * The URL of the site.
     */
    @SerializedName(value = "webUrl", alternate = {"WebUrl"})
    @Expose
	@Nullable
    public String webUrl;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
