// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.KeyCredential;
import com.microsoft.graph.models.PasswordCredential;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Application Add Key Parameter Set.
 */
public class ApplicationAddKeyParameterSet {
    /**
     * The key Credential.
     * 
     */
    @SerializedName(value = "keyCredential", alternate = {"KeyCredential"})
    @Expose
	@Nullable
    public KeyCredential keyCredential;

    /**
     * The password Credential.
     * 
     */
    @SerializedName(value = "passwordCredential", alternate = {"PasswordCredential"})
    @Expose
	@Nullable
    public PasswordCredential passwordCredential;

    /**
     * The proof.
     * 
     */
    @SerializedName(value = "proof", alternate = {"Proof"})
    @Expose
	@Nullable
    public String proof;


    /**
     * Instiaciates a new ApplicationAddKeyParameterSet
     */
    public ApplicationAddKeyParameterSet() {}
    /**
     * Instiaciates a new ApplicationAddKeyParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ApplicationAddKeyParameterSet(@Nonnull final ApplicationAddKeyParameterSetBuilder builder) {
        this.keyCredential = builder.keyCredential;
        this.passwordCredential = builder.passwordCredential;
        this.proof = builder.proof;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ApplicationAddKeyParameterSetBuilder newBuilder() {
        return new ApplicationAddKeyParameterSetBuilder();
    }
    /**
     * Fluent builder for the ApplicationAddKeyParameterSet
     */
    public static final class ApplicationAddKeyParameterSetBuilder {
        /**
         * The keyCredential parameter value
         */
        @Nullable
        protected KeyCredential keyCredential;
        /**
         * Sets the KeyCredential
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ApplicationAddKeyParameterSetBuilder withKeyCredential(@Nullable final KeyCredential val) {
            this.keyCredential = val;
            return this;
        }
        /**
         * The passwordCredential parameter value
         */
        @Nullable
        protected PasswordCredential passwordCredential;
        /**
         * Sets the PasswordCredential
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ApplicationAddKeyParameterSetBuilder withPasswordCredential(@Nullable final PasswordCredential val) {
            this.passwordCredential = val;
            return this;
        }
        /**
         * The proof parameter value
         */
        @Nullable
        protected String proof;
        /**
         * Sets the Proof
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ApplicationAddKeyParameterSetBuilder withProof(@Nullable final String val) {
            this.proof = val;
            return this;
        }
        /**
         * Instanciates a new ApplicationAddKeyParameterSetBuilder
         */
        @Nullable
        protected ApplicationAddKeyParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ApplicationAddKeyParameterSet build() {
            return new ApplicationAddKeyParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.keyCredential != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("keyCredential", keyCredential));
        }
        if(this.passwordCredential != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("passwordCredential", passwordCredential));
        }
        if(this.proof != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("proof", proof));
        }
        return result;
    }
}
