// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.Simulation;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Simulation Request.
 */
public class SimulationRequest extends BaseRequest<Simulation> {
	
    /**
     * The request for the Simulation
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SimulationRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Simulation.class);
    }

    /**
     * Gets the Simulation from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Simulation> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the Simulation from the service
     *
     * @return the Simulation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Simulation get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Simulation> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public Simulation delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Simulation with a source
     *
     * @param sourceSimulation the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Simulation> patchAsync(@Nonnull final Simulation sourceSimulation) {
        return sendAsync(HttpMethod.PATCH, sourceSimulation);
    }

    /**
     * Patches this Simulation with a source
     *
     * @param sourceSimulation the source object with updates
     * @return the updated Simulation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Simulation patch(@Nonnull final Simulation sourceSimulation) throws ClientException {
        return send(HttpMethod.PATCH, sourceSimulation);
    }

    /**
     * Creates a Simulation with a new object
     *
     * @param newSimulation the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Simulation> postAsync(@Nonnull final Simulation newSimulation) {
        return sendAsync(HttpMethod.POST, newSimulation);
    }

    /**
     * Creates a Simulation with a new object
     *
     * @param newSimulation the new object to create
     * @return the created Simulation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Simulation post(@Nonnull final Simulation newSimulation) throws ClientException {
        return send(HttpMethod.POST, newSimulation);
    }

    /**
     * Creates a Simulation with a new object
     *
     * @param newSimulation the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<Simulation> putAsync(@Nonnull final Simulation newSimulation) {
        return sendAsync(HttpMethod.PUT, newSimulation);
    }

    /**
     * Creates a Simulation with a new object
     *
     * @param newSimulation the object to create/update
     * @return the created Simulation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public Simulation put(@Nonnull final Simulation newSimulation) throws ClientException {
        return send(HttpMethod.PUT, newSimulation);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SimulationRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SimulationRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

