// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AttachmentBase;
import com.microsoft.graph.models.AttachmentInfo;
import com.microsoft.graph.models.UploadSession;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Attachment Base Request.
 */
public class AttachmentBaseRequest extends BaseRequest<AttachmentBase> {
	
    /**
     * The request for the AttachmentBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param responseClass  the class of the response
     */
    public AttachmentBaseRequest(@Nonnull final String requestUrl,
            @Nonnull final IBaseClient<?> client,
            @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions,
            @Nonnull final Class<? extends AttachmentBase> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    /**
     * The request for the AttachmentBase
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AttachmentBaseRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AttachmentBase.class);
    }

    /**
     * Gets the AttachmentBase from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentBase> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AttachmentBase from the service
     *
     * @return the AttachmentBase from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttachmentBase get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentBase> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AttachmentBase delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AttachmentBase with a source
     *
     * @param sourceAttachmentBase the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentBase> patchAsync(@Nonnull final AttachmentBase sourceAttachmentBase) {
        return sendAsync(HttpMethod.PATCH, sourceAttachmentBase);
    }

    /**
     * Patches this AttachmentBase with a source
     *
     * @param sourceAttachmentBase the source object with updates
     * @return the updated AttachmentBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttachmentBase patch(@Nonnull final AttachmentBase sourceAttachmentBase) throws ClientException {
        return send(HttpMethod.PATCH, sourceAttachmentBase);
    }

    /**
     * Creates a AttachmentBase with a new object
     *
     * @param newAttachmentBase the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentBase> postAsync(@Nonnull final AttachmentBase newAttachmentBase) {
        return sendAsync(HttpMethod.POST, newAttachmentBase);
    }

    /**
     * Creates a AttachmentBase with a new object
     *
     * @param newAttachmentBase the new object to create
     * @return the created AttachmentBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttachmentBase post(@Nonnull final AttachmentBase newAttachmentBase) throws ClientException {
        return send(HttpMethod.POST, newAttachmentBase);
    }

    /**
     * Creates a AttachmentBase with a new object
     *
     * @param newAttachmentBase the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AttachmentBase> putAsync(@Nonnull final AttachmentBase newAttachmentBase) {
        return sendAsync(HttpMethod.PUT, newAttachmentBase);
    }

    /**
     * Creates a AttachmentBase with a new object
     *
     * @param newAttachmentBase the object to create/update
     * @return the created AttachmentBase
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AttachmentBase put(@Nonnull final AttachmentBase newAttachmentBase) throws ClientException {
        return send(HttpMethod.PUT, newAttachmentBase);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AttachmentBaseRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AttachmentBaseRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

