// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.termstore.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.termstore.models.LocalizedName;
import com.microsoft.graph.models.KeyValue;
import com.microsoft.graph.termstore.models.Group;
import com.microsoft.graph.models.Entity;
import com.microsoft.graph.termstore.requests.RelationCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Set.
 */
public class Set extends Entity implements IJsonBackedObject {


    /**
     * The Created Date Time.
     * Date and time of set creation. Read-only.
     */
    @SerializedName(value = "createdDateTime", alternate = {"CreatedDateTime"})
    @Expose
	@Nullable
    public java.time.OffsetDateTime createdDateTime;

    /**
     * The Description.
     * Description that gives details on the term usage.
     */
    @SerializedName(value = "description", alternate = {"Description"})
    @Expose
	@Nullable
    public String description;

    /**
     * The Localized Names.
     * Name of the set for each languageTag.
     */
    @SerializedName(value = "localizedNames", alternate = {"LocalizedNames"})
    @Expose
	@Nullable
    public java.util.List<LocalizedName> localizedNames;

    /**
     * The Properties.
     * Custom properties for the set.
     */
    @SerializedName(value = "properties", alternate = {"Properties"})
    @Expose
	@Nullable
    public java.util.List<KeyValue> properties;

    /**
     * The Children.
     * Children terms of set in term [store].
     */
    @SerializedName(value = "children", alternate = {"Children"})
    @Expose
	@Nullable
    public com.microsoft.graph.termstore.requests.TermCollectionPage children;

    /**
     * The Parent Group.
     * The parent [group] that contains the set.
     */
    @SerializedName(value = "parentGroup", alternate = {"ParentGroup"})
    @Expose
	@Nullable
    public Group parentGroup;

    /**
     * The Relations.
     * Indicates which terms have been pinned or reused directly under the set.
     */
    @SerializedName(value = "relations", alternate = {"Relations"})
    @Expose
	@Nullable
    public com.microsoft.graph.termstore.requests.RelationCollectionPage relations;

    /**
     * The Terms.
     * All the terms under the set.
     */
    @SerializedName(value = "terms", alternate = {"Terms"})
    @Expose
	@Nullable
    public com.microsoft.graph.termstore.requests.TermCollectionPage terms;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {


        if (json.has("children")) {
            children = serializer.deserializeObject(json.get("children"), com.microsoft.graph.termstore.requests.TermCollectionPage.class);
        }

        if (json.has("relations")) {
            relations = serializer.deserializeObject(json.get("relations"), com.microsoft.graph.termstore.requests.RelationCollectionPage.class);
        }

        if (json.has("terms")) {
            terms = serializer.deserializeObject(json.get("terms"), com.microsoft.graph.termstore.requests.TermCollectionPage.class);
        }
    }
}
