// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.InferenceClassificationOverride;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Inference Classification Override Request.
 */
public class InferenceClassificationOverrideRequest extends BaseRequest<InferenceClassificationOverride> {
	
    /**
     * The request for the InferenceClassificationOverride
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public InferenceClassificationOverrideRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, InferenceClassificationOverride.class);
    }

    /**
     * Gets the InferenceClassificationOverride from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassificationOverride> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the InferenceClassificationOverride from the service
     *
     * @return the InferenceClassificationOverride from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InferenceClassificationOverride get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassificationOverride> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public InferenceClassificationOverride delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this InferenceClassificationOverride with a source
     *
     * @param sourceInferenceClassificationOverride the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassificationOverride> patchAsync(@Nonnull final InferenceClassificationOverride sourceInferenceClassificationOverride) {
        return sendAsync(HttpMethod.PATCH, sourceInferenceClassificationOverride);
    }

    /**
     * Patches this InferenceClassificationOverride with a source
     *
     * @param sourceInferenceClassificationOverride the source object with updates
     * @return the updated InferenceClassificationOverride
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InferenceClassificationOverride patch(@Nonnull final InferenceClassificationOverride sourceInferenceClassificationOverride) throws ClientException {
        return send(HttpMethod.PATCH, sourceInferenceClassificationOverride);
    }

    /**
     * Creates a InferenceClassificationOverride with a new object
     *
     * @param newInferenceClassificationOverride the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassificationOverride> postAsync(@Nonnull final InferenceClassificationOverride newInferenceClassificationOverride) {
        return sendAsync(HttpMethod.POST, newInferenceClassificationOverride);
    }

    /**
     * Creates a InferenceClassificationOverride with a new object
     *
     * @param newInferenceClassificationOverride the new object to create
     * @return the created InferenceClassificationOverride
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InferenceClassificationOverride post(@Nonnull final InferenceClassificationOverride newInferenceClassificationOverride) throws ClientException {
        return send(HttpMethod.POST, newInferenceClassificationOverride);
    }

    /**
     * Creates a InferenceClassificationOverride with a new object
     *
     * @param newInferenceClassificationOverride the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<InferenceClassificationOverride> putAsync(@Nonnull final InferenceClassificationOverride newInferenceClassificationOverride) {
        return sendAsync(HttpMethod.PUT, newInferenceClassificationOverride);
    }

    /**
     * Creates a InferenceClassificationOverride with a new object
     *
     * @param newInferenceClassificationOverride the object to create/update
     * @return the created InferenceClassificationOverride
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public InferenceClassificationOverride put(@Nonnull final InferenceClassificationOverride newInferenceClassificationOverride) throws ClientException {
        return send(HttpMethod.PUT, newInferenceClassificationOverride);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public InferenceClassificationOverrideRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public InferenceClassificationOverrideRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

