// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.WorkbookFunctionResult;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Functions Beta_Inv Parameter Set.
 */
public class WorkbookFunctionsBeta_InvParameterSet {
    /**
     * The probability.
     * 
     */
    @SerializedName(value = "probability", alternate = {"Probability"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement probability;

    /**
     * The alpha.
     * 
     */
    @SerializedName(value = "alpha", alternate = {"Alpha"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement alpha;

    /**
     * The beta.
     * 
     */
    @SerializedName(value = "beta", alternate = {"Beta"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement beta;

    /**
     * The a.
     * 
     */
    @SerializedName(value = "a", alternate = {"A"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement a;

    /**
     * The b.
     * 
     */
    @SerializedName(value = "b", alternate = {"B"})
    @Expose
	@Nullable
    public com.google.gson.JsonElement b;


    /**
     * Instiaciates a new WorkbookFunctionsBeta_InvParameterSet
     */
    public WorkbookFunctionsBeta_InvParameterSet() {}
    /**
     * Instiaciates a new WorkbookFunctionsBeta_InvParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected WorkbookFunctionsBeta_InvParameterSet(@Nonnull final WorkbookFunctionsBeta_InvParameterSetBuilder builder) {
        this.probability = builder.probability;
        this.alpha = builder.alpha;
        this.beta = builder.beta;
        this.a = builder.a;
        this.b = builder.b;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static WorkbookFunctionsBeta_InvParameterSetBuilder newBuilder() {
        return new WorkbookFunctionsBeta_InvParameterSetBuilder();
    }
    /**
     * Fluent builder for the WorkbookFunctionsBeta_InvParameterSet
     */
    public static final class WorkbookFunctionsBeta_InvParameterSetBuilder {
        /**
         * The probability parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement probability;
        /**
         * Sets the Probability
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBeta_InvParameterSetBuilder withProbability(@Nullable final com.google.gson.JsonElement val) {
            this.probability = val;
            return this;
        }
        /**
         * The alpha parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement alpha;
        /**
         * Sets the Alpha
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBeta_InvParameterSetBuilder withAlpha(@Nullable final com.google.gson.JsonElement val) {
            this.alpha = val;
            return this;
        }
        /**
         * The beta parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement beta;
        /**
         * Sets the Beta
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBeta_InvParameterSetBuilder withBeta(@Nullable final com.google.gson.JsonElement val) {
            this.beta = val;
            return this;
        }
        /**
         * The a parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement a;
        /**
         * Sets the A
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBeta_InvParameterSetBuilder withA(@Nullable final com.google.gson.JsonElement val) {
            this.a = val;
            return this;
        }
        /**
         * The b parameter value
         */
        @Nullable
        protected com.google.gson.JsonElement b;
        /**
         * Sets the B
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public WorkbookFunctionsBeta_InvParameterSetBuilder withB(@Nullable final com.google.gson.JsonElement val) {
            this.b = val;
            return this;
        }
        /**
         * Instanciates a new WorkbookFunctionsBeta_InvParameterSetBuilder
         */
        @Nullable
        protected WorkbookFunctionsBeta_InvParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public WorkbookFunctionsBeta_InvParameterSet build() {
            return new WorkbookFunctionsBeta_InvParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.probability != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("probability", probability));
        }
        if(this.alpha != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("alpha", alpha));
        }
        if(this.beta != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("beta", beta));
        }
        if(this.a != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("a", a));
        }
        if(this.b != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("b", b));
        }
        return result;
    }
}
