/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.DataSource;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataSourceRequest
extends BaseRequest<DataSource> {
    public DataSourceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions, @Nonnull Class<? extends DataSource> responseClass) {
        super(requestUrl, client, requestOptions, responseClass);
    }

    public DataSourceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DataSource.class);
    }

    @Nonnull
    public CompletableFuture<DataSource> getAsync() {
        return this.sendAsync(HttpMethod.GET, null);
    }

    @Nullable
    public DataSource get() throws ClientException {
        return (DataSource)this.send(HttpMethod.GET, null);
    }

    @Nonnull
    public CompletableFuture<DataSource> deleteAsync() {
        return this.sendAsync(HttpMethod.DELETE, null);
    }

    @Nullable
    public DataSource delete() throws ClientException {
        return (DataSource)this.send(HttpMethod.DELETE, null);
    }

    @Nonnull
    public CompletableFuture<DataSource> patchAsync(@Nonnull DataSource sourceDataSource) {
        return this.sendAsync(HttpMethod.PATCH, sourceDataSource);
    }

    @Nullable
    public DataSource patch(@Nonnull DataSource sourceDataSource) throws ClientException {
        return (DataSource)this.send(HttpMethod.PATCH, sourceDataSource);
    }

    @Nonnull
    public CompletableFuture<DataSource> postAsync(@Nonnull DataSource newDataSource) {
        return this.sendAsync(HttpMethod.POST, newDataSource);
    }

    @Nullable
    public DataSource post(@Nonnull DataSource newDataSource) throws ClientException {
        return (DataSource)this.send(HttpMethod.POST, newDataSource);
    }

    @Nonnull
    public CompletableFuture<DataSource> putAsync(@Nonnull DataSource newDataSource) {
        return this.sendAsync(HttpMethod.PUT, newDataSource);
    }

    @Nullable
    public DataSource put(@Nonnull DataSource newDataSource) throws ClientException {
        return (DataSource)this.send(HttpMethod.PUT, newDataSource);
    }

    @Nonnull
    public DataSourceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DataSourceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }
}

