/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseEntityCollectionRequest;
import com.microsoft.graph.models.DocumentSetVersion;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.requests.DocumentSetVersionCollectionPage;
import com.microsoft.graph.requests.DocumentSetVersionCollectionRequestBuilder;
import com.microsoft.graph.requests.DocumentSetVersionCollectionResponse;
import com.microsoft.graph.requests.DocumentSetVersionRequestBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentSetVersionCollectionRequest
extends BaseEntityCollectionRequest<DocumentSetVersion, DocumentSetVersionCollectionResponse, DocumentSetVersionCollectionPage> {
    public DocumentSetVersionCollectionRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DocumentSetVersionCollectionResponse.class, DocumentSetVersionCollectionPage.class, DocumentSetVersionCollectionRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<DocumentSetVersion> postAsync(@Nonnull DocumentSetVersion newDocumentSetVersion) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DocumentSetVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).postAsync(newDocumentSetVersion);
    }

    @Nonnull
    public DocumentSetVersion post(@Nonnull DocumentSetVersion newDocumentSetVersion) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DocumentSetVersionRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDocumentSetVersion);
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest count() {
        this.addCountOption(true);
        return this;
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest skip(int value) {
        this.addSkipOption(value);
        return this;
    }

    @Nonnull
    public DocumentSetVersionCollectionRequest skipToken(@Nonnull String skipToken) {
        this.addSkipTokenOption(skipToken);
        return this;
    }
}

