/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.security.requests;

import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionWithReferencesRequest;
import com.microsoft.graph.http.ReferenceRequestBody;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.security.models.Alert;
import com.microsoft.graph.security.requests.AlertCollectionResponse;
import com.microsoft.graph.security.requests.AlertCollectionWithReferencesPage;
import com.microsoft.graph.security.requests.AlertCollectionWithReferencesRequest;
import com.microsoft.graph.security.requests.AlertCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.security.requests.AlertReferenceRequestBuilder;
import com.microsoft.graph.security.requests.AlertWithReferenceRequest;
import com.microsoft.graph.security.requests.AlertWithReferenceRequestBuilder;
import com.microsoft.graph.serializer.IJsonBackedObject;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AlertCollectionReferenceRequest
extends BaseCollectionWithReferencesRequest<Alert, AlertWithReferenceRequest, AlertReferenceRequestBuilder, AlertWithReferenceRequestBuilder, AlertCollectionResponse, AlertCollectionWithReferencesPage, AlertCollectionWithReferencesRequest> {
    public AlertCollectionReferenceRequest(@Nonnull String requestUrl, @Nonnull IBaseClient<?> client, @Nullable List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, AlertCollectionResponse.class, AlertCollectionWithReferencesPage.class, AlertCollectionWithReferencesRequestBuilder.class);
    }

    @Nonnull
    public CompletableFuture<Alert> postAsync(@Nonnull Alert newAlert) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/security/alerts/" + newAlert.id);
        return ((AlertWithReferenceRequest)new AlertWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).postAsync(newAlert, (IJsonBackedObject)body);
    }

    @Nonnull
    public Alert post(@Nonnull Alert newAlert) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        ReferenceRequestBody body = new ReferenceRequestBody(this.getBaseRequest().getClient().getServiceRoot() + "/security/alerts/" + newAlert.id);
        return (Alert)((AlertWithReferenceRequest)new AlertWithReferenceRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders())).post(newAlert, (IJsonBackedObject)body);
    }

    @Nonnull
    public AlertCollectionReferenceRequest expand(@Nonnull String value) {
        this.addExpandOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionReferenceRequest filter(@Nonnull String value) {
        this.addFilterOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionReferenceRequest orderBy(@Nonnull String value) {
        this.addOrderByOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionReferenceRequest select(@Nonnull String value) {
        this.addSelectOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionReferenceRequest top(int value) {
        this.addTopOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionReferenceRequest count(boolean value) {
        this.addCountOption(value);
        return this;
    }

    @Nonnull
    public AlertCollectionReferenceRequest count() {
        this.addCountOption(true);
        return this;
    }
}

