// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TelecomExpenseManagementPartner;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Telecom Expense Management Partner Request.
 */
public class TelecomExpenseManagementPartnerRequest extends BaseRequest<TelecomExpenseManagementPartner> {
	
    /**
     * The request for the TelecomExpenseManagementPartner
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TelecomExpenseManagementPartnerRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TelecomExpenseManagementPartner.class);
    }

    /**
     * Gets the TelecomExpenseManagementPartner from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TelecomExpenseManagementPartner> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the TelecomExpenseManagementPartner from the service
     *
     * @return the TelecomExpenseManagementPartner from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TelecomExpenseManagementPartner get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TelecomExpenseManagementPartner> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public TelecomExpenseManagementPartner delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TelecomExpenseManagementPartner with a source
     *
     * @param sourceTelecomExpenseManagementPartner the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TelecomExpenseManagementPartner> patchAsync(@Nonnull final TelecomExpenseManagementPartner sourceTelecomExpenseManagementPartner) {
        return sendAsync(HttpMethod.PATCH, sourceTelecomExpenseManagementPartner);
    }

    /**
     * Patches this TelecomExpenseManagementPartner with a source
     *
     * @param sourceTelecomExpenseManagementPartner the source object with updates
     * @return the updated TelecomExpenseManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TelecomExpenseManagementPartner patch(@Nonnull final TelecomExpenseManagementPartner sourceTelecomExpenseManagementPartner) throws ClientException {
        return send(HttpMethod.PATCH, sourceTelecomExpenseManagementPartner);
    }

    /**
     * Creates a TelecomExpenseManagementPartner with a new object
     *
     * @param newTelecomExpenseManagementPartner the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TelecomExpenseManagementPartner> postAsync(@Nonnull final TelecomExpenseManagementPartner newTelecomExpenseManagementPartner) {
        return sendAsync(HttpMethod.POST, newTelecomExpenseManagementPartner);
    }

    /**
     * Creates a TelecomExpenseManagementPartner with a new object
     *
     * @param newTelecomExpenseManagementPartner the new object to create
     * @return the created TelecomExpenseManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TelecomExpenseManagementPartner post(@Nonnull final TelecomExpenseManagementPartner newTelecomExpenseManagementPartner) throws ClientException {
        return send(HttpMethod.POST, newTelecomExpenseManagementPartner);
    }

    /**
     * Creates a TelecomExpenseManagementPartner with a new object
     *
     * @param newTelecomExpenseManagementPartner the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<TelecomExpenseManagementPartner> putAsync(@Nonnull final TelecomExpenseManagementPartner newTelecomExpenseManagementPartner) {
        return sendAsync(HttpMethod.PUT, newTelecomExpenseManagementPartner);
    }

    /**
     * Creates a TelecomExpenseManagementPartner with a new object
     *
     * @param newTelecomExpenseManagementPartner the object to create/update
     * @return the created TelecomExpenseManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public TelecomExpenseManagementPartner put(@Nonnull final TelecomExpenseManagementPartner newTelecomExpenseManagementPartner) throws ClientException {
        return send(HttpMethod.PUT, newTelecomExpenseManagementPartner);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public TelecomExpenseManagementPartnerRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public TelecomExpenseManagementPartnerRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

