// Template Source: BaseEntity.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.EnumSet;
import com.microsoft.graph.http.BaseCollectionPage;
import com.microsoft.graph.models.KeyValuePair;


import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Subject Rights Request Detail.
 */
public class SubjectRightsRequestDetail implements IJsonBackedObject {

    /** the OData type of the object as returned by the service */
    @SerializedName("@odata.type")
    @Expose
    @Nullable
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    @Nonnull
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Excluded Item Count.
     * Count of items that are excluded from the request.
     */
    @SerializedName(value = "excludedItemCount", alternate = {"ExcludedItemCount"})
    @Expose
	@Nullable
    public Long excludedItemCount;

    /**
     * The Insight Counts.
     * Count of items per insight.
     */
    @SerializedName(value = "insightCounts", alternate = {"InsightCounts"})
    @Expose
	@Nullable
    public java.util.List<KeyValuePair> insightCounts;

    /**
     * The Item Count.
     * Count of items found.
     */
    @SerializedName(value = "itemCount", alternate = {"ItemCount"})
    @Expose
	@Nullable
    public Long itemCount;

    /**
     * The Item Need Review.
     * Count of item that need review.
     */
    @SerializedName(value = "itemNeedReview", alternate = {"ItemNeedReview"})
    @Expose
	@Nullable
    public Long itemNeedReview;

    /**
     * The Product Item Counts.
     * Count of items per product, such as Exchange, SharePoint, OneDrive, and Teams.
     */
    @SerializedName(value = "productItemCounts", alternate = {"ProductItemCounts"})
    @Expose
	@Nullable
    public java.util.List<KeyValuePair> productItemCounts;

    /**
     * The Signed Off Item Count.
     * Count of items signed off by the administrator.
     */
    @SerializedName(value = "signedOffItemCount", alternate = {"SignedOffItemCount"})
    @Expose
	@Nullable
    public Long signedOffItemCount;

    /**
     * The Total Item Size.
     * Total item size in bytes.
     */
    @SerializedName(value = "totalItemSize", alternate = {"TotalItemSize"})
    @Expose
	@Nullable
    public Long totalItemSize;


    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(@Nonnull final ISerializer serializer, @Nonnull final JsonObject json) {

    }
}
