// Template Source: BaseEntityRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.TemporaryAccessPassAuthenticationMethodConfiguration;
import com.microsoft.graph.requests.AuthenticationMethodTargetCollectionRequestBuilder;
import com.microsoft.graph.requests.AuthenticationMethodTargetRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Temporary Access Pass Authentication Method Configuration Request Builder.
 */
public class TemporaryAccessPassAuthenticationMethodConfigurationRequestBuilder extends BaseRequestBuilder<TemporaryAccessPassAuthenticationMethodConfiguration> {

    /**
     * The request builder for the TemporaryAccessPassAuthenticationMethodConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TemporaryAccessPassAuthenticationMethodConfigurationRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @param requestOptions the options for this request
     * @return the TemporaryAccessPassAuthenticationMethodConfigurationRequest instance
     */
    @Nonnull
    public TemporaryAccessPassAuthenticationMethodConfigurationRequest buildRequest(@Nullable final com.microsoft.graph.options.Option... requestOptions) {
        return buildRequest(getOptions(requestOptions));
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the TemporaryAccessPassAuthenticationMethodConfigurationRequest instance
     */
    @Nonnull
    public TemporaryAccessPassAuthenticationMethodConfigurationRequest buildRequest(@Nonnull final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        return new com.microsoft.graph.requests.TemporaryAccessPassAuthenticationMethodConfigurationRequest(getRequestUrl(), getClient(), requestOptions);
    }


    /**
     *  Gets a request builder for the AuthenticationMethodTarget collection
     *
     * @return the collection request builder
     */
    @Nonnull
    public AuthenticationMethodTargetCollectionRequestBuilder includeTargets() {
        return new AuthenticationMethodTargetCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("includeTargets"), getClient(), null);
    }

    /**
     * Gets a request builder for the AuthenticationMethodTarget item
     *
     * @return the request builder
     * @param id the item identifier
     */
    @Nonnull
    public AuthenticationMethodTargetRequestBuilder includeTargets(@Nonnull final String id) {
        return new AuthenticationMethodTargetRequestBuilder(getRequestUrlWithAdditionalSegment("includeTargets") + "/" + id, getClient(), null);
    }
}
