// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.SharedWithChannelTeamInfo;
import com.microsoft.graph.requests.ConversationMemberCollectionWithReferencesRequestBuilder;
import com.microsoft.graph.requests.ConversationMemberWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shared With Channel Team Info Request.
 */
public class SharedWithChannelTeamInfoRequest extends BaseRequest<SharedWithChannelTeamInfo> {
	
    /**
     * The request for the SharedWithChannelTeamInfo
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public SharedWithChannelTeamInfoRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, SharedWithChannelTeamInfo.class);
    }

    /**
     * Gets the SharedWithChannelTeamInfo from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedWithChannelTeamInfo> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the SharedWithChannelTeamInfo from the service
     *
     * @return the SharedWithChannelTeamInfo from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharedWithChannelTeamInfo get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedWithChannelTeamInfo> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public SharedWithChannelTeamInfo delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this SharedWithChannelTeamInfo with a source
     *
     * @param sourceSharedWithChannelTeamInfo the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedWithChannelTeamInfo> patchAsync(@Nonnull final SharedWithChannelTeamInfo sourceSharedWithChannelTeamInfo) {
        return sendAsync(HttpMethod.PATCH, sourceSharedWithChannelTeamInfo);
    }

    /**
     * Patches this SharedWithChannelTeamInfo with a source
     *
     * @param sourceSharedWithChannelTeamInfo the source object with updates
     * @return the updated SharedWithChannelTeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharedWithChannelTeamInfo patch(@Nonnull final SharedWithChannelTeamInfo sourceSharedWithChannelTeamInfo) throws ClientException {
        return send(HttpMethod.PATCH, sourceSharedWithChannelTeamInfo);
    }

    /**
     * Creates a SharedWithChannelTeamInfo with a new object
     *
     * @param newSharedWithChannelTeamInfo the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedWithChannelTeamInfo> postAsync(@Nonnull final SharedWithChannelTeamInfo newSharedWithChannelTeamInfo) {
        return sendAsync(HttpMethod.POST, newSharedWithChannelTeamInfo);
    }

    /**
     * Creates a SharedWithChannelTeamInfo with a new object
     *
     * @param newSharedWithChannelTeamInfo the new object to create
     * @return the created SharedWithChannelTeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharedWithChannelTeamInfo post(@Nonnull final SharedWithChannelTeamInfo newSharedWithChannelTeamInfo) throws ClientException {
        return send(HttpMethod.POST, newSharedWithChannelTeamInfo);
    }

    /**
     * Creates a SharedWithChannelTeamInfo with a new object
     *
     * @param newSharedWithChannelTeamInfo the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<SharedWithChannelTeamInfo> putAsync(@Nonnull final SharedWithChannelTeamInfo newSharedWithChannelTeamInfo) {
        return sendAsync(HttpMethod.PUT, newSharedWithChannelTeamInfo);
    }

    /**
     * Creates a SharedWithChannelTeamInfo with a new object
     *
     * @param newSharedWithChannelTeamInfo the object to create/update
     * @return the created SharedWithChannelTeamInfo
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public SharedWithChannelTeamInfo put(@Nonnull final SharedWithChannelTeamInfo newSharedWithChannelTeamInfo) throws ClientException {
        return send(HttpMethod.PUT, newSharedWithChannelTeamInfo);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public SharedWithChannelTeamInfoRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public SharedWithChannelTeamInfoRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

