// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.List;
import com.microsoft.graph.requests.ColumnDefinitionCollectionRequestBuilder;
import com.microsoft.graph.requests.ColumnDefinitionRequestBuilder;
import com.microsoft.graph.requests.ContentTypeCollectionRequestBuilder;
import com.microsoft.graph.requests.ContentTypeRequestBuilder;
import com.microsoft.graph.requests.DriveRequestBuilder;
import com.microsoft.graph.requests.ListItemCollectionRequestBuilder;
import com.microsoft.graph.requests.ListItemRequestBuilder;
import com.microsoft.graph.requests.RichLongRunningOperationCollectionRequestBuilder;
import com.microsoft.graph.requests.RichLongRunningOperationRequestBuilder;
import com.microsoft.graph.requests.SubscriptionCollectionRequestBuilder;
import com.microsoft.graph.requests.SubscriptionRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the List Request.
 */
public class ListRequest extends BaseRequest<List> {
	
    /**
     * The request for the List
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ListRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, List.class);
    }

    /**
     * Gets the List from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<List> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the List from the service
     *
     * @return the List from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public List get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<List> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public List delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this List with a source
     *
     * @param sourceList the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<List> patchAsync(@Nonnull final List sourceList) {
        return sendAsync(HttpMethod.PATCH, sourceList);
    }

    /**
     * Patches this List with a source
     *
     * @param sourceList the source object with updates
     * @return the updated List
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public List patch(@Nonnull final List sourceList) throws ClientException {
        return send(HttpMethod.PATCH, sourceList);
    }

    /**
     * Creates a List with a new object
     *
     * @param newList the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<List> postAsync(@Nonnull final List newList) {
        return sendAsync(HttpMethod.POST, newList);
    }

    /**
     * Creates a List with a new object
     *
     * @param newList the new object to create
     * @return the created List
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public List post(@Nonnull final List newList) throws ClientException {
        return send(HttpMethod.POST, newList);
    }

    /**
     * Creates a List with a new object
     *
     * @param newList the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<List> putAsync(@Nonnull final List newList) {
        return sendAsync(HttpMethod.PUT, newList);
    }

    /**
     * Creates a List with a new object
     *
     * @param newList the object to create/update
     * @return the created List
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public List put(@Nonnull final List newList) throws ClientException {
        return send(HttpMethod.PUT, newList);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ListRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ListRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

