// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.ChecklistItem;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Checklist Item Request.
 */
public class ChecklistItemRequest extends BaseRequest<ChecklistItem> {
	
    /**
     * The request for the ChecklistItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ChecklistItemRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, ChecklistItem.class);
    }

    /**
     * Gets the ChecklistItem from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChecklistItem> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the ChecklistItem from the service
     *
     * @return the ChecklistItem from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChecklistItem get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChecklistItem> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public ChecklistItem delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this ChecklistItem with a source
     *
     * @param sourceChecklistItem the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChecklistItem> patchAsync(@Nonnull final ChecklistItem sourceChecklistItem) {
        return sendAsync(HttpMethod.PATCH, sourceChecklistItem);
    }

    /**
     * Patches this ChecklistItem with a source
     *
     * @param sourceChecklistItem the source object with updates
     * @return the updated ChecklistItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChecklistItem patch(@Nonnull final ChecklistItem sourceChecklistItem) throws ClientException {
        return send(HttpMethod.PATCH, sourceChecklistItem);
    }

    /**
     * Creates a ChecklistItem with a new object
     *
     * @param newChecklistItem the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChecklistItem> postAsync(@Nonnull final ChecklistItem newChecklistItem) {
        return sendAsync(HttpMethod.POST, newChecklistItem);
    }

    /**
     * Creates a ChecklistItem with a new object
     *
     * @param newChecklistItem the new object to create
     * @return the created ChecklistItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChecklistItem post(@Nonnull final ChecklistItem newChecklistItem) throws ClientException {
        return send(HttpMethod.POST, newChecklistItem);
    }

    /**
     * Creates a ChecklistItem with a new object
     *
     * @param newChecklistItem the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<ChecklistItem> putAsync(@Nonnull final ChecklistItem newChecklistItem) {
        return sendAsync(HttpMethod.PUT, newChecklistItem);
    }

    /**
     * Creates a ChecklistItem with a new object
     *
     * @param newChecklistItem the object to create/update
     * @return the created ChecklistItem
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public ChecklistItem put(@Nonnull final ChecklistItem newChecklistItem) throws ClientException {
        return send(HttpMethod.PUT, newChecklistItem);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public ChecklistItemRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public ChecklistItemRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

