// Template Source: BaseEntityRequest.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AuthenticationMethodsPolicy;
import com.microsoft.graph.requests.AuthenticationMethodConfigurationCollectionRequestBuilder;
import com.microsoft.graph.requests.AuthenticationMethodConfigurationRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Authentication Methods Policy Request.
 */
public class AuthenticationMethodsPolicyRequest extends BaseRequest<AuthenticationMethodsPolicy> {
	
    /**
     * The request for the AuthenticationMethodsPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AuthenticationMethodsPolicyRequest(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AuthenticationMethodsPolicy.class);
    }

    /**
     * Gets the AuthenticationMethodsPolicy from the service
     *
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodsPolicy> getAsync() {
        return sendAsync(HttpMethod.GET, null);
    }

    /**
     * Gets the AuthenticationMethodsPolicy from the service
     *
     * @return the AuthenticationMethodsPolicy from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodsPolicy get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @return a future with the deletion result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodsPolicy> deleteAsync() {
        return sendAsync(HttpMethod.DELETE, null);
    }

    /**
     * Delete this item from the service
     * @return the resulting response if the service returns anything on deletion
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    @Nullable
    public AuthenticationMethodsPolicy delete() throws ClientException {
        return send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this AuthenticationMethodsPolicy with a source
     *
     * @param sourceAuthenticationMethodsPolicy the source object with updates
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodsPolicy> patchAsync(@Nonnull final AuthenticationMethodsPolicy sourceAuthenticationMethodsPolicy) {
        return sendAsync(HttpMethod.PATCH, sourceAuthenticationMethodsPolicy);
    }

    /**
     * Patches this AuthenticationMethodsPolicy with a source
     *
     * @param sourceAuthenticationMethodsPolicy the source object with updates
     * @return the updated AuthenticationMethodsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodsPolicy patch(@Nonnull final AuthenticationMethodsPolicy sourceAuthenticationMethodsPolicy) throws ClientException {
        return send(HttpMethod.PATCH, sourceAuthenticationMethodsPolicy);
    }

    /**
     * Creates a AuthenticationMethodsPolicy with a new object
     *
     * @param newAuthenticationMethodsPolicy the new object to create
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodsPolicy> postAsync(@Nonnull final AuthenticationMethodsPolicy newAuthenticationMethodsPolicy) {
        return sendAsync(HttpMethod.POST, newAuthenticationMethodsPolicy);
    }

    /**
     * Creates a AuthenticationMethodsPolicy with a new object
     *
     * @param newAuthenticationMethodsPolicy the new object to create
     * @return the created AuthenticationMethodsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodsPolicy post(@Nonnull final AuthenticationMethodsPolicy newAuthenticationMethodsPolicy) throws ClientException {
        return send(HttpMethod.POST, newAuthenticationMethodsPolicy);
    }

    /**
     * Creates a AuthenticationMethodsPolicy with a new object
     *
     * @param newAuthenticationMethodsPolicy the object to create/update
     * @return a future with the result
     */
    @Nonnull
    public java.util.concurrent.CompletableFuture<AuthenticationMethodsPolicy> putAsync(@Nonnull final AuthenticationMethodsPolicy newAuthenticationMethodsPolicy) {
        return sendAsync(HttpMethod.PUT, newAuthenticationMethodsPolicy);
    }

    /**
     * Creates a AuthenticationMethodsPolicy with a new object
     *
     * @param newAuthenticationMethodsPolicy the object to create/update
     * @return the created AuthenticationMethodsPolicy
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    @Nullable
    public AuthenticationMethodsPolicy put(@Nonnull final AuthenticationMethodsPolicy newAuthenticationMethodsPolicy) throws ClientException {
        return send(HttpMethod.PUT, newAuthenticationMethodsPolicy);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationMethodsPolicyRequest select(@Nonnull final String value) {
         addSelectOption(value);
         return this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     @Nonnull
     public AuthenticationMethodsPolicyRequest expand(@Nonnull final String value) {
         addExpandOption(value);
         return this;
     }

}

