// Template Source: BaseEntityWithReferenceRequestBuilder.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.AccessPackageAssignment;
import com.microsoft.graph.models.AccessPackageAssignmentFilterByCurrentUserOptions;
import com.microsoft.graph.requests.AccessPackageWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AccessPackageAssignmentPolicyWithReferenceRequestBuilder;
import com.microsoft.graph.requests.AccessPackageSubjectWithReferenceRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import javax.annotation.Nonnull;

import com.microsoft.graph.http.BaseWithReferenceRequestBuilder;
import com.microsoft.graph.core.IBaseClient;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Access Package Assignment With Reference Request Builder.
 */
public class AccessPackageAssignmentWithReferenceRequestBuilder extends BaseWithReferenceRequestBuilder<AccessPackageAssignment, AccessPackageAssignmentWithReferenceRequest, AccessPackageAssignmentReferenceRequestBuilder> {

    /**
     * The request builder for the AccessPackageAssignment
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public AccessPackageAssignmentWithReferenceRequestBuilder(@Nonnull final String requestUrl, @Nonnull final IBaseClient<?> client, @Nullable final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, AccessPackageAssignmentWithReferenceRequest.class, AccessPackageAssignmentReferenceRequestBuilder.class);
    }
}
