// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;


import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Schedule Change Request Approve Parameter Set.
 */
public class ScheduleChangeRequestApproveParameterSet {
    /**
     * The message.
     * 
     */
    @SerializedName(value = "message", alternate = {"Message"})
    @Expose
	@Nullable
    public String message;


    /**
     * Instiaciates a new ScheduleChangeRequestApproveParameterSet
     */
    public ScheduleChangeRequestApproveParameterSet() {}
    /**
     * Instiaciates a new ScheduleChangeRequestApproveParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ScheduleChangeRequestApproveParameterSet(@Nonnull final ScheduleChangeRequestApproveParameterSetBuilder builder) {
        this.message = builder.message;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ScheduleChangeRequestApproveParameterSetBuilder newBuilder() {
        return new ScheduleChangeRequestApproveParameterSetBuilder();
    }
    /**
     * Fluent builder for the ScheduleChangeRequestApproveParameterSet
     */
    public static final class ScheduleChangeRequestApproveParameterSetBuilder {
        /**
         * The message parameter value
         */
        @Nullable
        protected String message;
        /**
         * Sets the Message
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ScheduleChangeRequestApproveParameterSetBuilder withMessage(@Nullable final String val) {
            this.message = val;
            return this;
        }
        /**
         * Instanciates a new ScheduleChangeRequestApproveParameterSetBuilder
         */
        @Nullable
        protected ScheduleChangeRequestApproveParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ScheduleChangeRequestApproveParameterSet build() {
            return new ScheduleChangeRequestApproveParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.message != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("message", message));
        }
        return result;
    }
}
