// Template Source: BaseMethodParameterSet.java.tt
// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models;

import com.microsoft.graph.models.ContentType;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.EnumSet;
import java.util.ArrayList;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Content Type Add Copy From Content Type Hub Parameter Set.
 */
public class ContentTypeAddCopyFromContentTypeHubParameterSet {
    /**
     * The content Type Id.
     * 
     */
    @SerializedName(value = "contentTypeId", alternate = {"ContentTypeId"})
    @Expose
	@Nullable
    public String contentTypeId;


    /**
     * Instiaciates a new ContentTypeAddCopyFromContentTypeHubParameterSet
     */
    public ContentTypeAddCopyFromContentTypeHubParameterSet() {}
    /**
     * Instiaciates a new ContentTypeAddCopyFromContentTypeHubParameterSet
     * @param builder builder bearing the parameters to initialize from
     */
    protected ContentTypeAddCopyFromContentTypeHubParameterSet(@Nonnull final ContentTypeAddCopyFromContentTypeHubParameterSetBuilder builder) {
        this.contentTypeId = builder.contentTypeId;
    }
    /**
     * Gets a new builder for the body
     * @return a new builder
     */
    @Nonnull
    public static ContentTypeAddCopyFromContentTypeHubParameterSetBuilder newBuilder() {
        return new ContentTypeAddCopyFromContentTypeHubParameterSetBuilder();
    }
    /**
     * Fluent builder for the ContentTypeAddCopyFromContentTypeHubParameterSet
     */
    public static final class ContentTypeAddCopyFromContentTypeHubParameterSetBuilder {
        /**
         * The contentTypeId parameter value
         */
        @Nullable
        protected String contentTypeId;
        /**
         * Sets the ContentTypeId
         * @param val the value to set it to
         * @return the current builder object
         */
        @Nonnull
        public ContentTypeAddCopyFromContentTypeHubParameterSetBuilder withContentTypeId(@Nullable final String val) {
            this.contentTypeId = val;
            return this;
        }
        /**
         * Instanciates a new ContentTypeAddCopyFromContentTypeHubParameterSetBuilder
         */
        @Nullable
        protected ContentTypeAddCopyFromContentTypeHubParameterSetBuilder(){}
        /**
         * Buils the resulting body object to be passed to the request
         * @return the body object to pass to the request
         */
        @Nonnull
        public ContentTypeAddCopyFromContentTypeHubParameterSet build() {
            return new ContentTypeAddCopyFromContentTypeHubParameterSet(this);
        }
    }
    /**
     * Gets the functions options from the properties that have been set
     * @return a list of function options for the request
     */
    @Nonnull
    public java.util.List<com.microsoft.graph.options.FunctionOption> getFunctionOptions() {
        final ArrayList<com.microsoft.graph.options.FunctionOption> result = new ArrayList<>();
        if(this.contentTypeId != null) {
            result.add(new com.microsoft.graph.options.FunctionOption("contentTypeId", contentTypeId));
        }
        return result;
    }
}
